/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.pool;

import com.complexible.common.pool.Poolable;
import java.io.Closeable;
import org.apache.commons.pool.PoolableObjectFactory;

public class DefaultPoolableObjectFactory
implements PoolableObjectFactory {
    private final Class mClass;

    public DefaultPoolableObjectFactory(Class theClass) {
        this.mClass = theClass;
    }

    public Object makeObject() throws Exception {
        return this.mClass.newInstance();
    }

    public void destroyObject(Object o) throws Exception {
        if (o instanceof Closeable) {
            ((Closeable)o).close();
        }
    }

    public boolean validateObject(Object o) {
        return true;
    }

    public final void activateObject(Object o) throws Exception {
        if (o instanceof Poolable) {
            ((Poolable)o).activate();
        }
    }

    public final void passivateObject(Object o) throws Exception {
        if (o instanceof Poolable) {
            ((Poolable)o).deactivate();
        }
    }
}

