/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.nio;

import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;

public final class Channels2 {
    private Channels2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFully(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        if (channel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)((Object)channel);
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                if (!selectableChannel.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                Channels2.doWriteFully(channel, buffer);
            }
        } else {
            Channels2.doWriteFully(channel, buffer);
        }
    }

    @SuppressForbidden
    private static void doWriteFully(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            int written = channel.write(buffer);
            if (written > 0) continue;
            throw new IOException("Couldn't write any more bytes into the channel " + String.valueOf(channel));
        }
    }

    @SuppressForbidden
    public static void writeFullyAtPosition(FileChannel channel, ByteBuffer buffer, long position) throws IOException {
        while (buffer.remaining() > 0) {
            int written = channel.write(buffer, position);
            if (written <= 0) {
                throw new IOException("Couldn't write any more bytes into the channel " + String.valueOf(channel));
            }
            position += (long)written;
        }
    }
}

