/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.net;

import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import java.util.function.Predicate;

public final class MediaTypes {
    public static final MediaType MULTIPART_FORM_DATA = MediaType.create((String)"multipart", (String)"form-data");
    public static final MediaType MULTIPART_MIXED = MediaType.create((String)"multipart", (String)"mixed");
    public static final MediaType JSON = MediaType.create((String)"application", (String)"json");
    public static final MediaType TEXT = MediaType.create((String)"text", (String)"plain");
    public static final MediaType HTML = MediaType.create((String)"text", (String)"html");

    private MediaTypes() {
        throw new AssertionError();
    }

    public static Predicate<MediaType> is(MediaType theType) {
        return theMediaType -> theMediaType.is(theType);
    }

    public static boolean any(MediaType theType, MediaType theFirst, MediaType ... theRest) {
        if (theFirst.is(theType)) {
            return true;
        }
        if (theRest != null) {
            for (MediaType aType : theRest) {
                if (!aType.is(theType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCompatibleWith(MediaType theType, MediaType theOtherType) {
        return theType == null && theOtherType == null || theType != null && theOtherType != null && (theType.is(theOtherType) || theOtherType.is(theType));
    }

    public static boolean isCompatibleWith(String theType, String theOtherType) {
        return MediaTypes.isCompatibleWith(MediaTypes.parseMime(theType), MediaTypes.parseMime(theOtherType));
    }

    public static Predicate<MediaType> isCompatibleWith(String theType) {
        return theMediaType -> MediaTypes.isCompatibleWith(MediaTypes.parseMime(theType), theMediaType);
    }

    public static boolean isMultipart(MediaType theType) {
        return theType != null && (theType.is(MULTIPART_FORM_DATA) || theType.is(MULTIPART_MIXED));
    }

    public static MediaType parseMime(String theMime) {
        if (theMime == null) {
            return MediaType.ANY_TYPE;
        }
        try {
            MediaType aMediaType = MediaType.parse((String)theMime);
            return aMediaType.withParameters((Multimap)aMediaType.parameters());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

