/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.memory;

import java.util.HashMap;
import java.util.Map;

public interface MemoryConfiguration {
    public long getMemory(NativeComponent var1);

    public long getMemory(HeapComponent var1);

    public static enum NativeComponent {
        QUERY_MEM_BLOCKS("query"),
        STARROCKS_SIZE("starrocks");

        private final String mOption;
        private static final Map<String, NativeComponent> mStarrocksRatiosMap;

        public String getOption() {
            return this.mOption;
        }

        private NativeComponent(String theOption) {
            this.mOption = theOption;
        }

        public static NativeComponent getInstance(String theOption) {
            return mStarrocksRatiosMap.get(theOption);
        }

        static {
            mStarrocksRatiosMap = new HashMap<String, NativeComponent>();
            for (NativeComponent aRatio : NativeComponent.values()) {
                mStarrocksRatiosMap.put(aRatio.mOption, aRatio);
            }
        }
    }

    public static enum HeapComponent {
        DICT_VALUE_CACHE("dict_value"),
        DICT_INDEX_CACHE("dict_index");

        private final String mOption;
        private static final Map<String, HeapComponent> mStarrocksRatiosMap;

        public String getOption() {
            return this.mOption;
        }

        private HeapComponent(String theOption) {
            this.mOption = theOption;
        }

        public static HeapComponent getInstance(String theOption) {
            return mStarrocksRatiosMap.get(theOption);
        }

        static {
            mStarrocksRatiosMap = new HashMap<String, HeapComponent>();
            for (HeapComponent aRatio : HeapComponent.values()) {
                mStarrocksRatiosMap.put(aRatio.mOption, aRatio);
            }
        }
    }

    public static enum StarrocksComponent {
        MEMTABLE("memtable"),
        BLOCK_CACHE("block_cache"),
        DICT_BLOCK_CACHE("dict_block_cache"),
        TXN_BLOCK_CACHE("txn_block_cache"),
        UNTRACKED_MEMORY("untracked_memory");

        private final String mOption;
        private static final Map<String, StarrocksComponent> mStarrocksRatiosMap;

        public String getOption() {
            return this.mOption;
        }

        private StarrocksComponent(String theOption) {
            this.mOption = theOption;
        }

        public static StarrocksComponent getInstance(String theOption) {
            return mStarrocksRatiosMap.get(theOption);
        }

        static {
            mStarrocksRatiosMap = new HashMap<String, StarrocksComponent>();
            for (StarrocksComponent aRatio : StarrocksComponent.values()) {
                mStarrocksRatiosMap.put(aRatio.mOption, aRatio);
            }
        }
    }
}

