/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.mem;

import com.complexible.common.io.impl.AbstractByteWriter;
import com.complexible.common.primitives.Serializers;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Arrays;

public class MemoryByteWriter
extends AbstractByteWriter {
    protected byte[] bytes;
    protected int position;

    public MemoryByteWriter() {
        this(10);
    }

    public MemoryByteWriter(int theInitialCapacity) {
        this.bytes = new byte[theInitialCapacity];
        this.position = 0;
    }

    protected int incrementPosition(int theDelta) {
        int aPos = this.position;
        int aLength = this.bytes.length;
        this.position += theDelta;
        if (this.position > aLength) {
            int aNewLength = Math.max(aLength * 3 / 2 + 1, this.position);
            this.bytes = Arrays.copyOf(this.bytes, aNewLength);
        }
        return aPos;
    }

    @Override
    public void writeByte(byte b) {
        int pos = this.incrementPosition(1);
        this.bytes[pos] = b;
    }

    @Override
    public void writeShort(short theShort) throws IOException {
        int pos = this.incrementPosition(2);
        Serializers.SHORT.serialize(theShort, this.bytes, pos);
    }

    @Override
    public void writeInt(int i) throws IOException {
        int pos = this.incrementPosition(4);
        Serializers.INT.serialize(i, this.bytes, pos);
    }

    @Override
    public void writeLong(long i) throws IOException {
        int pos = this.incrementPosition(8);
        Serializers.LONG.serialize(i, this.bytes, pos);
    }

    @Override
    public void writeVInt(int i) throws IOException {
        int pos = this.incrementPosition(5);
        while ((i & 0xFFFFFF80) != 0) {
            this.bytes[pos++] = (byte)(i & 0x7F | 0x80);
            i >>>= 7;
        }
        this.bytes[pos++] = (byte)i;
        this.position = pos;
    }

    @Override
    public void writeVLong(long i) throws IOException {
        int pos = this.incrementPosition(10);
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.bytes[pos++] = (byte)(i & 0x7FL | 0x80L);
            i >>>= 7;
        }
        this.bytes[pos++] = (byte)i;
        this.position = pos;
    }

    @Override
    public long length() throws IOException {
        return this.bytes.length;
    }

    @Override
    public void setPosition(long thePosition) throws IOException {
        this.position = Ints.checkedCast((long)thePosition);
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    public byte[] toArray() {
        return Arrays.copyOfRange(this.bytes, 0, this.position);
    }

    public byte[] getArray() {
        return this.bytes;
    }
}

