/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.mem;

import com.complexible.common.io.CloneableByteReader;
import com.complexible.common.io.impl.AbstractByteReader;
import com.complexible.common.unsafe.UnsafeUtil;
import java.io.IOException;
import sun.misc.Unsafe;

public class MemoryByteReader
extends AbstractByteReader
implements CloneableByteReader {
    protected final byte[] bytes;
    protected final int offset;
    protected final int length;
    protected int current;

    public MemoryByteReader(byte[] theBytes) {
        this(theBytes, 0, theBytes.length);
    }

    public MemoryByteReader(byte[] theBytes, int theOffset, int theLength) {
        this.bytes = theBytes;
        this.offset = theOffset;
        this.length = theLength;
        this.current = this.offset;
    }

    @Override
    public byte readByte() {
        return this.bytes[this.current++];
    }

    @Override
    public void setPosition(long thePosition) {
        this.current = (int)thePosition + this.offset;
    }

    @Override
    public long getPosition() {
        return this.current - this.offset;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public int read(byte[] theData) throws IOException {
        return this.read(theData, 0, theData.length);
    }

    @Override
    public int read(byte[] theData, int offset, int length) throws IOException {
        System.arraycopy(this.bytes, this.current, theData, offset, length);
        this.current += length;
        return length;
    }

    @Override
    public int readNative(long address, int length) throws IOException {
        assert (UnsafeUtil.UNSAFE != null);
        UnsafeUtil.UNSAFE.copyMemory(this.bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.current * (long)Unsafe.ARRAY_BYTE_INDEX_SCALE, null, address, length);
        this.current += length;
        return length;
    }

    @Override
    public MemoryByteReader clone() {
        return new MemoryByteReader(this.bytes, this.offset, this.length);
    }
}

