/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.Page;
import com.complexible.common.io.PageByteWriter;
import com.complexible.common.io.PagedFile;
import com.complexible.common.io.impl.AbstractByteWriter;
import com.complexible.common.io.impl.AbstractPage;
import com.complexible.common.io.mem.MemoryByteReader;
import com.complexible.common.primitives.Serializers;
import com.google.common.base.Preconditions;
import java.io.IOException;

final class SinglePage
extends AbstractPage {
    private static final int HEADER_SIZE = 4;

    public SinglePage(PagedFile theFile, long theFilePosition, long theID) {
        super(theFile, theFilePosition, theID);
    }

    @Override
    public int getMaxSize() {
        return this.mPagedFile.getPageSize() - 4;
    }

    @Override
    public ByteReader read() throws IOException {
        int aPageSize = this.mPagedFile.getPageSize();
        byte[] data = new byte[aPageSize];
        this.mPagedFile.getFile().read(data, this.mFilePosition);
        int length = Serializers.INT.deserialize(data, 0);
        if (length > this.getMaxSize()) {
            throw new IOException("Data is too big for page. " + length + " > " + this.getMaxSize());
        }
        return new MemoryByteReader(data, 4, length){

            public String toString() {
                return SinglePage.this.toString();
            }
        };
    }

    @Override
    public PageByteWriter write() throws IOException {
        return new Writer(this);
    }

    @Override
    public PageByteWriter append() throws IOException {
        int aPageSize = this.mPagedFile.getPageSize();
        byte[] data = new byte[aPageSize];
        this.mPagedFile.getFile().read(data, this.mFilePosition);
        int length = Serializers.INT.deserialize(data, 0);
        return new Writer(this, data, length);
    }

    private static class Writer
    extends AbstractByteWriter
    implements PageByteWriter {
        private final byte[] bytes;
        private int maxPosition;
        private int position;
        private boolean overflowed;
        private SinglePage page;

        public Writer(SinglePage p) {
            this.page = p;
            this.bytes = new byte[this.page.mPagedFile.getPageSize()];
            this.maxPosition = this.bytes.length - 4;
            this.position = 0;
            this.overflowed = false;
        }

        public Writer(SinglePage p, byte[] theData, int thePosition) {
            this.page = p;
            this.bytes = theData;
            this.maxPosition = this.bytes.length - 4;
            this.position = thePosition;
            this.overflowed = false;
        }

        @Override
        public boolean isOverflowed() {
            return this.overflowed;
        }

        private int offset(int delta) {
            int offset = 4 + this.position;
            this.position += delta;
            boolean bl = this.overflowed = this.overflowed || this.position > this.maxPosition;
            if (this.overflowed) {
                this.position -= delta;
                offset = -1;
            }
            return offset;
        }

        @Override
        public void writeByte(byte b) {
            int offset = this.offset(1);
            if (offset != -1) {
                this.bytes[offset] = b;
            }
        }

        @Override
        public void writeShort(short theShort) throws IOException {
            int offset = this.offset(2);
            if (offset != -1) {
                Serializers.SHORT.serialize(theShort, this.bytes, offset);
            }
        }

        @Override
        public void writeInt(int i) throws IOException {
            int offset = this.offset(4);
            if (offset != -1) {
                Serializers.INT.serialize(i, this.bytes, offset);
            }
        }

        @Override
        public void writeLong(long i) throws IOException {
            int offset = this.offset(8);
            if (offset != -1) {
                Serializers.LONG.serialize(i, this.bytes, offset);
            }
        }

        @Override
        public void write(byte[] theData, int theOffset, int theLength) throws IOException {
            int offset = this.offset(theLength);
            if (offset != -1) {
                System.arraycopy(theData, theOffset, this.bytes, offset, theLength);
            }
        }

        @Override
        public void limit(int thePageLimit) {
            Preconditions.checkArgument((thePageLimit >= this.position ? 1 : 0) != 0, (String)"The limit cannot be less than the current position: %s < %s", (int)thePageLimit, (int)this.maxPosition);
            Preconditions.checkArgument((thePageLimit <= this.page.mPagedFile.getPageSize() ? 1 : 0) != 0, (String)"The limit cannot be greater than the page size: %s >= %s", (int)thePageLimit, (int)this.maxPosition);
            this.maxPosition = thePageLimit;
        }

        @Override
        public long length() throws IOException {
            return this.page.getMaxSize();
        }

        @Override
        public void setPosition(long thePosition) throws IOException {
            this.position = (int)thePosition;
        }

        @Override
        public long getPosition() {
            return this.position;
        }

        @Override
        public void flush() throws IOException {
            Serializers.INT.serialize(this.position, this.bytes, 0);
            this.page.mPagedFile.getFile().write(this.bytes, this.page.mFilePosition, 0, 4 + this.position);
        }
    }

    public static class Factory
    implements Page.Factory {
        @Override
        public SinglePage create(PagedFile theFile, long theFilePosition, long theID) {
            return new SinglePage(theFile, theFilePosition, theID);
        }

        @Override
        public int getReservedPageSize() {
            return 4;
        }
    }
}

