/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.IOFile;
import com.complexible.common.io.Page;
import com.complexible.common.io.PageManager;
import com.complexible.common.io.PagedFile;
import com.complexible.common.io.PagedFileFactory;
import com.complexible.common.io.disk.DiskDirectory;
import com.complexible.common.io.disk.DiskFile;
import com.complexible.common.io.impl.PageNotFoundException;
import com.complexible.common.io.impl.SerialFileCreator;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PageManagerImpl
implements PageManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageManager.class);
    private static final long BEGIN_VALUE = Integer.MIN_VALUE;
    private static final long END_VALUE = -1L;
    private static final int RESERVED_SIZE = 16;
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private final int mID = ID_GENERATOR.getAndIncrement();
    private final int mPageSize;
    private final long mMaxFilesize;
    private final int mMaxNumberPagesPerFile;
    private final Page.Factory mPageFactory;
    private final SerialFileCreator mFileCreator;
    private final List<PagedFile> mFiles;
    private PagedFile mLastFile = null;
    private final Lock mCreatePageLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<Long> mFreePages;
    private final PagedFileFactory mPagedFileFactory;
    private boolean mHideFreePages = false;
    private boolean mClosed;

    PageManagerImpl(DiskDirectory theDirectory, String theFilename, PagedFileFactory thePFFactory, Page.Factory thePageFactory, long theMaxFilesize, int thePageSize, boolean clear, boolean isTemporary, boolean isReadOnly) throws IOException {
        if (thePageSize < 16) {
            throw new IllegalArgumentException("Page size too small: " + thePageSize);
        }
        this.mPageSize = thePageSize;
        this.mMaxFilesize = theMaxFilesize;
        this.mMaxNumberPagesPerFile = (int)((this.mMaxFilesize - 8L) / (long)this.mPageSize);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Page manager: {}/{} Page size: {}, Max file size: {} Max pages per file: {} ", new Object[]{theDirectory, theFilename, this.mPageSize, this.mMaxFilesize, this.mMaxNumberPagesPerFile});
        }
        this.mPagedFileFactory = thePFFactory;
        this.mPageFactory = thePageFactory;
        IOFile.Mode aMode = isReadOnly ? IOFile.Mode.READ_ONLY : IOFile.Mode.READ_WRITE;
        this.mFileCreator = new SerialFileCreator(theDirectory, theFilename, clear ? SerialFileCreator.DirectoryMode.CLEAR : SerialFileCreator.DirectoryMode.KEEP_FIRSTS_ORDERED, aMode);
        this.mFiles = this.initPagedFiles();
        if (!this.mFiles.isEmpty()) {
            this.mLastFile = this.mFiles.get(this.mFiles.size() - 1);
        }
        this.mClosed = false;
        this.mFreePages = Queues.newConcurrentLinkedQueue();
        if (!isTemporary) {
            theDirectory.clearTempFiles();
        }
        if (!$assertionsDisabled) {
            this.mHideFreePages = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    @Override
    public int getID() {
        return this.mID;
    }

    @Override
    public int getFreePageCount() {
        return this.mFreePages.size();
    }

    @Override
    public int getMaxNumberPagesPerFile() {
        return this.mMaxNumberPagesPerFile;
    }

    @Override
    public Page getPage(long theID) throws IOException {
        if (this.mHideFreePages && this.mFreePages.contains(theID)) {
            throw new PageNotFoundException(theID);
        }
        return this.getPageInternal(theID);
    }

    private Page getPageInternal(long thePageID) throws IOException {
        int aFileID = (int)(thePageID / (long)this.mMaxNumberPagesPerFile);
        if (aFileID >= this.mFiles.size()) {
            throw new PageNotFoundException(thePageID);
        }
        int aFilePageID = (int)(thePageID - (long)(aFileID * this.mMaxNumberPagesPerFile));
        return this.mFiles.get(aFileID).getPage(aFilePageID);
    }

    @Override
    public Page getPage(long theID, boolean create) throws IOException {
        if (create) {
            Page page;
            try {
                if (!this.mFiles.isEmpty()) {
                    return this.getPage(theID);
                }
            }
            catch (PageNotFoundException pageNotFoundException) {
                // empty catch block
            }
            while ((page = this.newPage()).getID() < theID) {
            }
            if (page.getID() != theID) {
                throw new IOException("Unable to create page " + theID);
            }
            return page;
        }
        return this.getPage(theID);
    }

    @Override
    public int getPageSize() {
        return this.mPageSize;
    }

    @Override
    public void freePage(long thePageID) {
        if (this.mHideFreePages && this.mFreePages.contains(thePageID)) {
            throw new IllegalArgumentException("Page already free: " + thePageID);
        }
        this.mFreePages.add(thePageID);
    }

    @Override
    public Page newPage() throws IOException {
        Long aPageID = this.mFreePages.poll();
        if (aPageID != null) {
            return this.getPageInternal(aPageID);
        }
        return this.createPage();
    }

    private Page createPage() throws IOException {
        this.mCreatePageLock.lock();
        try {
            Page aPage;
            if (this.mLastFile == null) {
                this.mLastFile = this.createNewFile();
            }
            if ((aPage = this.mLastFile.newPage()) == null) {
                aPage = this.createNewFile().newPage();
            }
            Page page = aPage;
            return page;
        }
        finally {
            this.mCreatePageLock.unlock();
        }
    }

    private PagedFile createNewFile() throws IOException {
        if (this.mLastFile != null) {
            this.mLastFile.flush();
        }
        this.mLastFile = this.mPagedFileFactory.create(this.mFileCreator.next(), this, this.mPageFactory, this.mFiles.size());
        this.mFiles.add(this.mLastFile);
        return this.mLastFile;
    }

    @Override
    public void flush() throws IOException {
        if (this.mClosed) {
            return;
        }
        IOException aException = null;
        for (PagedFile aFile : this.mFiles) {
            try {
                aFile.flush();
            }
            catch (IOException e) {
                aException = e;
            }
        }
        if (aException != null) {
            throw aException;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            for (PagedFile file : this.mFiles) {
                file.close();
            }
        }
    }

    private List<PagedFile> initPagedFiles() throws IOException {
        DiskFile[] aFiles = this.mFileCreator.getFiles();
        ArrayList validPages = Lists.newArrayListWithExpectedSize((int)aFiles.length);
        for (DiskFile aFile : aFiles) {
            validPages.add(this.mPagedFileFactory.create(aFile, this, this.mPageFactory, validPages.size()));
        }
        return validPages;
    }

    @Override
    public void clear() throws IOException {
        this.mCreatePageLock.lock();
        try {
            for (PagedFile file : this.mFiles) {
                file.clear();
                file.close();
            }
            this.mFileCreator.reload(SerialFileCreator.DirectoryMode.CLEAR);
            this.mFiles.clear();
            this.mLastFile = null;
            this.mFreePages.clear();
            assert (this.mFiles.size() == 0);
        }
        finally {
            this.mCreatePageLock.unlock();
        }
    }

    @Override
    public long size() {
        return this.mLastFile == null ? 0L : (long)((this.mFiles.size() - 1) * this.getMaxNumberPagesPerFile() + this.mLastFile.getNumberOfPages());
    }

    @Override
    public boolean repair(long theMaxPage) throws IOException {
        int aFileID = (int)(theMaxPage / (long)this.mMaxNumberPagesPerFile);
        if (aFileID != this.mFiles.size() - 1) {
            throw new IOException("Cannot repair page manager metadata, inconsistent file IDs: " + aFileID + " != " + (this.mFiles.size() - 1));
        }
        boolean aRepaired = false;
        for (int i = 0; i < aFileID - 1; ++i) {
            aRepaired |= this.mFiles.get(aFileID).repair(this.mMaxNumberPagesPerFile - 1);
        }
        int aMaxFilePage = (int)(theMaxPage - (long)(aFileID * this.mMaxNumberPagesPerFile));
        return aRepaired |= this.mFiles.get(aFileID).repair(aMaxFilePage);
    }

    @Override
    public PageManager createTempManager() throws IOException {
        DiskDirectory mTempDirectory = this.mFileCreator.getDirectory().getTemporary();
        String aTempName = mTempDirectory.getTempFilenamePart();
        return new PageManagerImpl(mTempDirectory, aTempName, this.mPagedFileFactory, this.mPageFactory, this.mMaxFilesize, this.mPageSize, true, true, false);
    }
}

