/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.ByteReader;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;

public final class ByteReaderInputStream
extends InputStream {
    private final ByteReader mReader;

    public ByteReaderInputStream(ByteReader theReader) {
        this.mReader = theReader;
    }

    @Override
    public int read() throws IOException {
        if (this.mReader.getPosition() == this.mReader.length()) {
            return -1;
        }
        return Byte.toUnsignedInt(this.mReader.readByte());
    }

    @Override
    public int available() throws IOException {
        return Ints.saturatedCast((long)(this.mReader.length() - this.mReader.getPosition()));
    }
}

