/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.impl.AbstractByteWriter;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;

public class ByteBufferByteWriter
extends AbstractByteWriter {
    protected ByteBuffer mBuffer;
    protected boolean mOverflow = false;

    public ByteBufferByteWriter(ByteBuffer theBuffer) {
        this.mBuffer = theBuffer;
        this.mBuffer.position(0);
    }

    @Override
    public boolean isOverflowed() {
        return this.mOverflow;
    }

    protected void checkOverflow(int theLength) {
        if (this.mBuffer.position() + theLength >= this.mBuffer.limit()) {
            this.mOverflow = true;
        }
    }

    @Override
    public long length() {
        return this.mBuffer.limit();
    }

    @Override
    public long getPosition() {
        return this.mBuffer.position();
    }

    @Override
    public void setPosition(long thePosition) {
        this.mBuffer.position(Ints.checkedCast((long)thePosition));
    }

    @Override
    public void write(byte[] theData) {
        this.checkOverflow(theData.length);
        if (!this.mOverflow) {
            this.mBuffer.put(theData, 0, theData.length);
        }
    }

    @Override
    public void writeByte(byte theValue) {
        this.checkOverflow(1);
        if (!this.mOverflow) {
            this.mBuffer.put(theValue);
        }
    }

    @Override
    public void write(byte[] theData, int theOffset, int theLength) {
        this.checkOverflow(theLength);
        if (!this.mOverflow) {
            this.mBuffer.put(theData, theOffset, theLength);
        }
    }

    @Override
    public void writeDouble(double theValue) {
        this.checkOverflow(8);
        if (!this.mOverflow) {
            this.mBuffer.putDouble(theValue);
        }
    }

    @Override
    public void writeFloat(float theValue) {
        this.checkOverflow(4);
        if (!this.mOverflow) {
            this.mBuffer.putFloat(theValue);
        }
    }

    @Override
    public void writeLong(long i) {
        this.checkOverflow(8);
        if (!this.mOverflow) {
            this.mBuffer.putLong(i);
        }
    }

    @Override
    public void writeShort(short theShort) {
        this.checkOverflow(2);
        if (!this.mOverflow) {
            this.mBuffer.putShort(theShort);
        }
    }

    @Override
    public void writeInt(int i) {
        this.checkOverflow(4);
        if (!this.mOverflow) {
            this.mBuffer.putInt(i);
        }
    }
}

