/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.CloneableByteReader;
import com.complexible.common.io.impl.AbstractByteReader;
import com.complexible.common.nio.ByteBuffers;
import com.google.common.base.Charsets;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class ByteBufferByteReader
extends AbstractByteReader
implements CloneableByteReader {
    private final ByteBuffer mBuffer;

    public ByteBufferByteReader(ByteBuffer theBuffer) {
        this.mBuffer = theBuffer;
    }

    @Override
    public long length() throws IOException {
        return this.mBuffer.limit();
    }

    @Override
    public long getPosition() throws IOException {
        return this.mBuffer.position();
    }

    @Override
    public void setPosition(long thePosition) throws IOException {
        this.mBuffer.position(Ints.checkedCast((long)thePosition));
    }

    @Override
    public int read(byte[] theData) throws IOException {
        this.mBuffer.get(theData, 0, theData.length);
        return theData.length;
    }

    @Override
    public byte readByte() throws IOException {
        return this.mBuffer.get();
    }

    @Override
    public int readInt() throws IOException {
        return this.mBuffer.getInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.mBuffer.getLong();
    }

    @Override
    public double readDouble() throws IOException {
        return this.mBuffer.getDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.mBuffer.getFloat();
    }

    @Override
    public String readString() throws IOException {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        this.read(bytes);
        return new String(bytes, Charsets.UTF_8);
    }

    @Override
    public short readShort() throws IOException {
        return this.mBuffer.getShort();
    }

    @Override
    public CloneableByteReader clone() {
        ByteBuffer copy = ByteBuffers.duplicate(this.mBuffer);
        copy.position(0);
        return new ByteBufferByteReader(copy);
    }
}

