/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.Directory;
import com.complexible.common.io.IOFile;
import com.complexible.common.io.impl.AbstractByteReader;
import com.google.common.base.Charsets;
import com.google.common.primitives.Shorts;
import java.io.IOException;

public abstract class AbstractFile
extends AbstractByteReader
implements IOFile {
    protected final IOFile.Mode mMode;
    protected final String mName;
    protected final Directory mDir;

    public AbstractFile(String theName, IOFile.Mode theMode, Directory theDir) {
        this.mName = theName;
        this.mMode = theMode;
        this.mDir = theDir;
    }

    @Override
    public Directory getDirectory() {
        return this.mDir;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public IOFile.Mode mode() {
        return this.mMode;
    }

    @Override
    public int read(byte[] theData) throws IOException {
        for (int i = 0; i < theData.length; ++i) {
            theData[i] = this.readByte();
        }
        return theData.length;
    }

    @Override
    public int read(byte[] theData, int offset, int size, long thePosition) throws IOException {
        for (int i = 0; i < size; ++i) {
            theData[offset + i] = this.readByte(thePosition + (long)i);
        }
        return theData.length;
    }

    @Override
    public int read(byte[] theData, long thePosition) throws IOException {
        return this.read(theData, 0, theData.length, thePosition);
    }

    @Override
    public int readInt(long thePosition) throws IOException {
        return (this.readByte(thePosition) & 0xFF) << 24 | (this.readByte(thePosition + 1L) & 0xFF) << 16 | (this.readByte(thePosition + 2L) & 0xFF) << 8 | this.readByte(thePosition + 3L) & 0xFF;
    }

    @Override
    public long readLong(long thePosition) throws IOException {
        return (long)this.readInt(thePosition) << 32 | (long)this.readInt(thePosition + 4L) & 0xFFFFFFFFL;
    }

    @Override
    public double readDouble(long thePosition) throws IOException {
        return Double.longBitsToDouble(this.readLong(thePosition));
    }

    @Override
    public float readFloat(long thePosition) throws IOException {
        return Float.intBitsToFloat(this.readInt(thePosition));
    }

    @Override
    public int readVInt(long thePosition) throws IOException {
        byte b = this.readByte(thePosition++);
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte(thePosition++);
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    @Override
    public long readVLong(long thePosition) throws IOException {
        byte b = this.readByte(thePosition++);
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte(thePosition++);
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    @Override
    public String readString(long thePosition) throws IOException {
        int length = this.readInt(thePosition);
        byte[] bytes = new byte[length];
        this.read(bytes, thePosition + 4L);
        return new String(bytes, 0, length, "UTF-8");
    }

    @Override
    public void write(byte[] theData) throws IOException {
        for (int i = 0; i < theData.length; ++i) {
            this.writeByte(theData[i]);
        }
    }

    @Override
    public void write(byte[] theData, long thePosition) throws IOException {
        for (int i = 0; i < theData.length; ++i) {
            this.writeByte(theData[i], thePosition + (long)i);
        }
    }

    @Override
    public void writeInt(int theValue) throws IOException {
        this.writeByte((byte)(theValue >> 24));
        this.writeByte((byte)(theValue >> 16));
        this.writeByte((byte)(theValue >> 8));
        this.writeByte((byte)theValue);
    }

    @Override
    public void writeInt(int theValue, long thePosition) throws IOException {
        this.writeByte((byte)(theValue >> 24), thePosition);
        this.writeByte((byte)(theValue >> 16), thePosition + 1L);
        this.writeByte((byte)(theValue >> 8), thePosition + 2L);
        this.writeByte((byte)theValue, thePosition + 3L);
    }

    @Override
    public void writeLong(long theValue) throws IOException {
        this.writeInt((int)(theValue >> 32));
        this.writeInt((int)theValue);
    }

    @Override
    public void writeLong(long theValue, long thePosition) throws IOException {
        this.writeInt((int)(theValue >> 32), thePosition);
        this.writeInt((int)theValue, thePosition + 4L);
    }

    @Override
    public void writeDouble(double theValue) throws IOException {
        this.writeLong(Double.doubleToLongBits(theValue));
    }

    @Override
    public void writeDouble(double theValue, long thePosition) throws IOException {
        this.writeLong(Double.doubleToLongBits(theValue), thePosition);
    }

    @Override
    public void writeFloat(float theValue) throws IOException {
        this.writeInt(Float.floatToIntBits(theValue));
    }

    @Override
    public void writeFloat(float theValue, long thePosition) throws IOException {
        this.writeInt(Float.floatToIntBits(theValue), thePosition);
    }

    @Override
    public void writeString(String theValue) throws IOException {
        byte[] aBytes = theValue.getBytes(Charsets.UTF_8);
        this.writeInt(aBytes.length);
        this.write(aBytes);
    }

    @Override
    public void writeString(String theValue, long thePosition) throws IOException {
        byte[] aBytes = theValue.getBytes(Charsets.UTF_8);
        this.writeInt(aBytes.length, thePosition);
        this.write(aBytes, thePosition + 4L);
    }

    @Override
    public void writeVInt(int theValue) throws IOException {
        while ((theValue & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(theValue & 0x7F | 0x80));
            theValue >>>= 7;
        }
        this.writeByte((byte)theValue);
    }

    @Override
    public void writeVInt(int theValue, long thePosition) throws IOException {
        while ((theValue & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(theValue & 0x7F | 0x80), thePosition++);
            theValue >>>= 7;
        }
        this.writeByte((byte)theValue, thePosition);
    }

    @Override
    public void writeVLong(long theValue) throws IOException {
        while ((theValue & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(theValue & 0x7FL | 0x80L));
            theValue >>>= 7;
        }
        this.writeByte((byte)theValue);
    }

    @Override
    public void writeVLong(long theValue, long thePosition) throws IOException {
        while ((theValue & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(theValue & 0x7FL | 0x80L), thePosition++);
            theValue >>>= 7;
        }
        this.writeByte((byte)theValue, thePosition);
    }

    @Override
    public void writeShort(short theValue) throws IOException {
        byte[] aBytes;
        for (byte aByte : aBytes = Shorts.toByteArray((short)theValue)) {
            this.writeByte(aByte);
        }
    }

    @Override
    public void write(byte[] theData, int theOffset, int theLength) throws IOException {
        this.write(theData, this.getPosition(), theOffset, theLength);
    }

    @Override
    public void write(byte[] theData, long thePosition, int theOffset, int theLength) throws IOException {
        int i = theOffset;
        int j = 0;
        while (i < theOffset + theLength && i < theData.length) {
            this.writeByte(theData[i], thePosition + (long)j);
            ++i;
            ++j;
        }
    }

    @Override
    public boolean isOverflowed() {
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

