/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.ByteWriter;
import com.google.common.base.Charsets;
import com.google.common.primitives.Shorts;
import java.io.IOException;

public abstract class AbstractByteWriter
implements ByteWriter {
    private static final int LONG_BIT_POSITION = 3;
    private static final int BITS_COUNT_BIT_POSITION = 3;
    public static final int LONG_SIZE_IN_BYTES = 8;
    private static final int LONG_MASK = 7;

    private static int divideLongPowerOfTwoAsInt(long theBase, int thePowerPosition) {
        return (int)(theBase >> thePowerPosition);
    }

    private static int maskLongPowerOfTwoAsInt(long theBase, int thePowerPosition) {
        return (int)(theBase & (long)thePowerPosition);
    }

    private static int multiplyIntPowerOfTwoAsInt(int theBase, int thePowerPosition) {
        return theBase << thePowerPosition;
    }

    private static byte divideLongPowerOfTwoAsByte(long theBase, int thePowerPosition) {
        return (byte)(theBase >> thePowerPosition);
    }

    @Override
    public boolean isOverflowed() {
        return false;
    }

    @Override
    public void write(byte[] theData) throws IOException {
        this.write(theData, 0, theData.length);
    }

    @Override
    public void write(byte[] theData, int theOffset, int theLength) throws IOException {
        for (int i = theOffset; i < theOffset + theLength && i < theData.length; ++i) {
            this.writeByte(theData[i]);
        }
    }

    @Override
    public void writeBuffer(long[] theData, int theOffset, int theLength) throws IOException {
        int start = theOffset / 8;
        int longCount = theLength / 8;
        for (int i = start; i < longCount; ++i) {
            this.writeLong(theData[i]);
        }
    }

    @Override
    public void writeDouble(double theValue) throws IOException {
        this.writeLong(Double.doubleToLongBits(theValue));
    }

    @Override
    public void writeFloat(float theValue) throws IOException {
        this.writeInt(Float.floatToIntBits(theValue));
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.writeInt((int)(i >> 32));
        this.writeInt((int)i);
    }

    @Override
    public void writeVLong(long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    @Override
    public void writeShort(short theShort) throws IOException {
        for (byte aByte : Shorts.toByteArray((short)theShort)) {
            this.writeByte(aByte);
        }
    }

    @Override
    public void writeChar(char theChar) throws IOException {
        this.writeByte((byte)(theChar >> 8));
        this.writeByte((byte)theChar);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.writeByte((byte)(i >> 24));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)i);
    }

    @Override
    public void writeVInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    @Override
    public void writeString(String theValue) throws IOException {
        byte[] aBytes = theValue.getBytes(Charsets.UTF_8);
        this.writeInt(aBytes.length);
        this.write(aBytes);
    }
}

