/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.disk;

import com.complexible.common.io.Files2;
import com.complexible.common.io.IOFile;
import com.complexible.common.io.disk.DiskFile;
import com.complexible.common.io.impl.AbstractDirectory;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;

public class DiskDirectory
extends AbstractDirectory {
    public static final String TEMP_PREFIX = "tempDir";
    private final Path mRootDir;
    private final DiskFile.Factory mFileFactory;
    private Path mTempDir;
    private boolean mDeletedTempDirOnClose = false;

    public DiskDirectory(Path theDirectory, DiskFile.Factory theFileFactory) throws IOException {
        this.mRootDir = theDirectory.toAbsolutePath();
        if (Files.exists(this.mRootDir, new LinkOption[0])) {
            if (!Files.isDirectory(this.mRootDir, new LinkOption[0])) {
                Files.delete(this.mRootDir);
                Files.createDirectory(this.mRootDir, new FileAttribute[0]);
            }
        } else {
            Files.createDirectories(this.mRootDir, new FileAttribute[0]);
        }
        this.mFileFactory = theFileFactory;
    }

    public String toString() {
        return this.mRootDir.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.mTempDir != null) {
            DiskDirectory diskDirectory = this;
            synchronized (diskDirectory) {
                if (this.mTempDir != null) {
                    Files2.deleteRecursively(this.mTempDir);
                    this.mTempDir = null;
                    this.mDeletedTempDirOnClose = true;
                }
            }
        }
    }

    @Override
    public void deleteFile(String theName) throws IOException {
        Files.delete(this.get(theName));
    }

    public boolean deleteFileIfExists(String theName) throws IOException {
        return Files.deleteIfExists(this.get(theName));
    }

    @Override
    public boolean fileExists(String theName) {
        return Files.exists(this.get(theName), new LinkOption[0]);
    }

    @Override
    public DiskFile getFile(String theName, IOFile.Mode theMode) throws IOException {
        return this.mFileFactory.create(this.get(theName), theMode, this);
    }

    @Override
    public List<String> getFileNames() throws IOException {
        return MoreFiles.listFiles((Path)this.mRootDir).stream().map(entry -> entry.getFileName().toString()).collect(Collectors.toList());
    }

    private Path get(String theName) {
        return this.mRootDir.resolve(theName);
    }

    @Override
    public void moveFilePersistently(String theOrigin, String theDestination) throws IOException {
        Files2.movePersistently(this.get(theOrigin), this.get(theDestination));
    }

    @Override
    public void copyFile(String theOrigin, String theDestination) throws IOException {
        Files.copy(this.get(theOrigin), this.get(theDestination), new CopyOption[0]);
    }

    public Path getRootDir() {
        return this.mRootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskDirectory getTemporary() throws IOException {
        if (this.mTempDir == null) {
            DiskDirectory diskDirectory = this;
            synchronized (diskDirectory) {
                if (this.mDeletedTempDirOnClose) {
                    throw new IllegalStateException("The directory is closed: " + String.valueOf(this.mRootDir));
                }
                if (this.mTempDir == null) {
                    this.mTempDir = Files.createTempDirectory(TEMP_PREFIX, new FileAttribute[0]);
                }
            }
        }
        return new DiskDirectory(this.mTempDir, this.mFileFactory);
    }

    public void clearTempFiles() throws IOException {
        if (this.mTempDir != null) {
            Files2.deleteDirectoryContents(this.mTempDir);
        }
    }

    @Override
    public void clearFiles() throws IOException {
        Files2.deleteDirectoryContents(this.mRootDir);
    }
}

