/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.block;

import com.complexible.common.io.block.BlockSpec;
import com.complexible.common.io.block.BlockWriter;
import java.io.Writer;

@Deprecated
public class HTMLBlockWriter
extends BlockWriter {
    private final StringBuilder currentLine = new StringBuilder();
    private boolean visibilityStyleSupported = true;
    private String backgroundColor = "white";
    private boolean offTheRecord = false;

    public HTMLBlockWriter(Writer out) {
        super(out, "&nbsp;");
    }

    @Override
    protected void startNewLine() {
        this.currentLine.setLength(0);
        HTMLBlock block = (HTMLBlock)this.currentBlock();
        if (block != null) {
            this.currentLine.append(block.indent);
            this.offTheRecord = true;
            if (this.isVisibilityStyleSupported()) {
                super.print("<span visibility='hidden'>");
                super.print(this.currentLine);
                super.print("</span>");
            } else {
                super.print("<font color='");
                super.print(this.getBackgroundColor());
                super.print("'>");
                super.print(this.currentLine);
                super.print("</font>");
            }
            this.offTheRecord = false;
        }
    }

    @Override
    public void println() {
        if (!this.offTheRecord) {
            this.offTheRecord = true;
            this.print("<br>");
            this.offTheRecord = false;
        }
        super.println();
    }

    @Override
    public void write(char[] buf, int off, int len) {
        super.write(buf, off, len);
        if (!this.offTheRecord) {
            this.currentLine.append(buf, off, len);
        }
    }

    @Override
    public void write(int c) {
        super.write(c);
        if (!this.offTheRecord) {
            this.currentLine.append(c);
        }
    }

    @Override
    public void write(String s, int off, int len) {
        super.write(s, off, len);
        if (!this.offTheRecord) {
            this.currentLine.append(s, off, len);
        }
    }

    public boolean isVisibilityStyleSupported() {
        return this.visibilityStyleSupported;
    }

    public void setVisibilityStyleSupported(boolean visibilityStyleSupported) {
        this.visibilityStyleSupported = visibilityStyleSupported;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    protected BlockWriter.Block createBlock(BlockSpec spec) {
        return new HTMLBlock(spec);
    }

    private class HTMLBlock
    extends BlockWriter.Block {
        private String indent;

        public HTMLBlock(BlockSpec spec) {
            super(HTMLBlockWriter.this, spec);
        }

        @Override
        protected void afterBegin() {
            String line = HTMLBlockWriter.this.currentLine.toString();
            if (!HTMLBlockWriter.this.isVisibilityStyleSupported()) {
                line = line.replaceAll("color=", "hidecolor=");
                line = line.replaceAll("href=", "hidehref=");
            }
            this.indent = line;
        }
    }
}

