/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.block;

import com.complexible.common.io.block.BlockSpec;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Deque;

public abstract class BlockWriter
extends PrintWriter {
    private static final BlockSpec INVISIBLE = BlockSpec.INDENTED.copy().indentSize(0).immutable();
    private final Deque<Block> blocks = Queues.newArrayDeque();
    private final String space;
    private int tabSize = 3;
    private boolean newLine = true;

    public BlockWriter(Writer out, String space) {
        super(out);
        Preconditions.checkNotNull((Object)space);
        this.space = space;
    }

    protected abstract void startNewLine();

    public void endBlocks() {
        while (!this.blocks.isEmpty()) {
            this.endBlock();
        }
    }

    protected abstract Block createBlock(BlockSpec var1);

    protected Block currentBlock() {
        return this.blocks.peek();
    }

    public void beginBlock(BlockSpec spec) {
        Block block = this.createBlock(spec);
        block.beforeBegin();
        this.blocks.push(block);
        block.afterBegin();
    }

    public BlockWriter beginBlock() {
        this.beginBlock(INVISIBLE);
        return this;
    }

    public BlockWriter endBlock() throws IllegalStateException {
        Preconditions.checkState((!this.blocks.isEmpty() ? 1 : 0) != 0, (Object)"No block to end!");
        Block block = this.blocks.peek();
        block.beforeEnd();
        this.blocks.pop();
        block.afterEnd();
        return this;
    }

    @Override
    public void println() {
        super.println();
        this.newLine = true;
    }

    @Override
    public void write(int c) {
        this.checkNewLine();
        super.write(c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.checkNewLine();
        super.write(buf, off, len);
    }

    @Override
    public void write(String s, int off, int len) {
        this.checkNewLine();
        super.write(s, off, len);
    }

    private void checkNewLine() {
        if (this.newLine) {
            this.newLine = false;
            this.startNewLine();
        }
    }

    public BlockWriter printSpace() {
        this.printSpace(1);
        return this;
    }

    public BlockWriter printSpace(int n) {
        for (int i = 0; i < n; ++i) {
            super.print(this.space);
        }
        return this;
    }

    public BlockWriter printTab() {
        this.printSpace(this.tabSize);
        return this;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    protected abstract class Block {
        private final BlockSpec spec;

        protected Block(BlockSpec spec) {
            this.spec = spec;
        }

        protected void beforeBegin() {
            if (this.spec.getTitle() != null) {
                BlockWriter.this.print(this.spec.getTitle());
                BlockWriter.this.printSpace();
            }
            if (this.spec.isNewLineBeforeBegin()) {
                BlockWriter.this.println();
            }
            if (this.spec.getBeginMarker() != null) {
                BlockWriter.this.print(this.spec.getBeginMarker());
            }
            if (this.spec.isNewLineAfterBegin()) {
                BlockWriter.this.println();
            }
            if (this.spec.getIndentSize() != 0) {
                BlockWriter.this.printSpace(this.spec.getIndentSize() < 0 ? BlockWriter.this.tabSize : this.spec.getIndentSize());
            }
        }

        protected void afterBegin() {
        }

        protected void beforeEnd() {
            if (this.spec.isNewLineBeforeEnd()) {
                BlockWriter.this.println();
            }
        }

        protected void afterEnd() {
            if (this.spec.getEndMarker() != null) {
                BlockWriter.this.print(this.spec.getEndMarker());
            }
            if (this.spec.isNewLineAfterEnd()) {
                BlockWriter.this.println();
            }
        }
    }
}

