/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLReaders {
    public static XMLReader createXMLReader(boolean isSecure) throws SAXException {
        XMLReader aReader = XMLReaders.createXMLReader();
        aReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", isSecure);
        if (isSecure) {
            aReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            aReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            aReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        return aReader;
    }

    private static XMLReader createXMLReader() throws SAXException {
        String XERCES_SAXPARSER = "org.apache.xerces.parsers.SAXParser";
        Logger logger = LoggerFactory.getLogger(XMLReader.class);
        XMLReader reader = null;
        String xmlReaderName = System.getProperty("org.xml.sax.driver");
        if (xmlReaderName != null) {
            try {
                reader = (XMLReader)Class.forName(xmlReaderName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Class " + xmlReaderName + " not found");
            }
            catch (ClassCastException e) {
                logger.warn(xmlReaderName + " is not a valid XMLReader.");
            }
            catch (Exception e) {
                logger.warn("could not create instance of " + xmlReaderName);
            }
            logger.debug("XMLReader initialized using system property: " + xmlReaderName);
        }
        if (reader == null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                reader = factory.newSAXParser().getXMLReader();
            }
            catch (NoClassDefFoundError e) {
                logger.warn("javax.xml.parsers.SAXParserFactory not available");
            }
            catch (Exception e) {
                logger.warn("Failed to initialize XMLReader through JAXP");
            }
            logger.debug("XMLReader initialized using JAXP: " + String.valueOf(reader));
        }
        if (reader == null) {
            try {
                reader = (XMLReader)Class.forName("org.apache.xerces.parsers.SAXParser").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                String message = "Class org.apache.xerces.parsers.SAXParser not found";
                logger.error(message);
                throw new SAXException(message);
            }
            catch (ClassCastException e) {
                String message = "org.apache.xerces.parsers.SAXParser is not a valid XMLReader.";
                logger.error(message);
                throw new SAXException(message);
            }
            catch (Exception e) {
                String message = "Could not create instance of org.apache.xerces.parsers.SAXParser";
                logger.error(message);
                throw new SAXException(message);
            }
            logger.debug("XMLReader initialized using default Xerces SAX parser org.apache.xerces.parsers.SAXParser");
        }
        return reader;
    }
}

