/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.io.FileRotationStrategy;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;

public final class TimeRotationStrategy
implements FileRotationStrategy {
    private final long mIntervalMillis;

    public TimeRotationStrategy(long theMilliseconds) {
        this.mIntervalMillis = theMilliseconds;
    }

    @Override
    public boolean needsRotation(Path theFile, long fileLength) throws IOException {
        return this.needsRotation(Files.getLastModifiedTime(theFile, new LinkOption[0]).toMillis(), System.currentTimeMillis());
    }

    @VisibleForTesting
    public boolean needsRotation(long theLastModifiedTimeMillis, long theTimeMillis) {
        long now = theTimeMillis / this.mIntervalMillis;
        long lastWrite = theLastModifiedTimeMillis / this.mIntervalMillis;
        return now > lastWrite;
    }

    public static TimeRotationStrategy create(String theInterval) {
        return new TimeRotationStrategy(TimeRotationStrategy.parseDH(theInterval));
    }

    private static long parseDH(String theStr) {
        int aLastIndex = theStr.length() - 1;
        TimeUnit aUnit = TimeRotationStrategy.getTimeUnit(theStr.charAt(aLastIndex));
        return TimeRotationStrategy.parseDuration(theStr.substring(0, aLastIndex), aUnit);
    }

    private static TimeUnit getTimeUnit(char theCh) {
        switch (Character.toLowerCase(theCh)) {
            case 'd': {
                return TimeUnit.DAYS;
            }
            case 'h': {
                return TimeUnit.HOURS;
            }
        }
        throw new IllegalArgumentException();
    }

    private static long parseHMS(String theStr) {
        String[] theFields = theStr.split("\\:");
        if (theFields.length != 3) {
            throw new IllegalArgumentException();
        }
        return TimeRotationStrategy.parseDuration(theFields[0], TimeUnit.HOURS) + TimeRotationStrategy.parseDuration(theFields[1], TimeUnit.MINUTES) + TimeRotationStrategy.parseDuration(theFields[2], TimeUnit.SECONDS);
    }

    private static long parseDuration(String theStr, TimeUnit theUnit) {
        int aVal = Integer.parseInt(theStr);
        if (aVal < 0) {
            throw new IllegalArgumentException();
        }
        return theUnit.toMillis(aVal);
    }
}

