/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.io.CachedSegmentedFile;
import com.complexible.common.io.SegmentedFile;
import com.google.common.base.Preconditions;
import java.nio.channels.FileChannel;

public final class SegmentedFileBuilder {
    private int mSegmentSize = 0x800000;
    private int mFileOffset = 0;
    private int mConcurrencyLevel = 16;
    private long mMaxMemory = 0x4000000L;
    private boolean mSliced = true;
    private boolean mCacheLastAccessedSegment = false;
    private FileChannel.MapMode mMapMode = FileChannel.MapMode.READ_WRITE;
    private FileChannel mChannel;

    public static SegmentedFileBuilder newBuilder() {
        return new SegmentedFileBuilder();
    }

    private SegmentedFileBuilder() {
    }

    public SegmentedFileBuilder file(FileChannel theChannel) {
        this.mChannel = theChannel;
        return this;
    }

    FileChannel file() {
        return this.mChannel;
    }

    public SegmentedFileBuilder fileOffset(int theOffset) {
        this.mFileOffset = theOffset;
        return this;
    }

    int fileOffset() {
        return this.mFileOffset;
    }

    public SegmentedFileBuilder segmentSize(int theSegmentSize) {
        this.mSegmentSize = theSegmentSize;
        return this;
    }

    int segmentSize() {
        return this.mSegmentSize;
    }

    public SegmentedFileBuilder maxMemory(long theMaxMemory) {
        Preconditions.checkArgument((theMaxMemory != 0L ? 1 : 0) != 0, (Object)"Max Memory cannot be zero");
        this.mMaxMemory = theMaxMemory;
        return this;
    }

    long maxMemory() {
        return this.mMaxMemory;
    }

    public SegmentedFileBuilder concurrencyLevel(int theConcurrencyLevel) {
        this.mConcurrencyLevel = theConcurrencyLevel;
        return this;
    }

    int concurrencyLevel() {
        return this.mConcurrencyLevel;
    }

    public SegmentedFileBuilder slicedBuffers(boolean theSliced) {
        this.mSliced = theSliced;
        return this;
    }

    boolean sliceBuffers() {
        return this.mSliced;
    }

    public SegmentedFileBuilder cacheLastAccessedSegment(boolean theValue) {
        this.mCacheLastAccessedSegment = theValue;
        return this;
    }

    boolean cacheLastAccessedSegment() {
        return this.mCacheLastAccessedSegment;
    }

    public SegmentedFileBuilder mapMode(FileChannel.MapMode theMapMode) {
        this.mMapMode = theMapMode;
        return this;
    }

    FileChannel.MapMode mapMode() {
        return this.mMapMode;
    }

    public SegmentedFile build() {
        Preconditions.checkNotNull((Object)this.mChannel, (Object)"File channel cannot be null");
        return new CachedSegmentedFile(this);
    }
}

