/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.collect.ArrayIterable;
import com.google.common.collect.ObjectArrays;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;

public final class MultiOutputStream
extends OutputStream {
    private final Iterable<OutputStream> mOutputStreams;

    private MultiOutputStream(Iterable<OutputStream> theOutputStreams) {
        this.mOutputStreams = theOutputStreams;
    }

    public static MultiOutputStream create(Iterable<OutputStream> theOutputStreams) {
        return new MultiOutputStream(theOutputStreams);
    }

    public static MultiOutputStream create(OutputStream theStream, OutputStream ... theRest) {
        return new MultiOutputStream(new ArrayIterable<OutputStream>((OutputStream[])ObjectArrays.concat((Object)theStream, (Object[])theRest)));
    }

    @Override
    public void close() throws IOException {
        Closer aCloser = Closer.create();
        for (OutputStream aOut : this.mOutputStreams) {
            aCloser.register((Closeable)aOut);
        }
        aCloser.close();
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream aOut : this.mOutputStreams) {
            aOut.flush();
        }
    }

    @Override
    public void write(byte[] theBytes) throws IOException {
        for (OutputStream aOut : this.mOutputStreams) {
            aOut.write(theBytes);
        }
    }

    @Override
    public void write(byte[] theBytes, int theOffset, int theLength) throws IOException {
        for (OutputStream aOut : this.mOutputStreams) {
            aOut.write(theBytes, theOffset, theLength);
        }
    }

    @Override
    public void write(int theByte) throws IOException {
        for (OutputStream aOut : this.mOutputStreams) {
            aOut.write(theByte);
        }
    }
}

