/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MoreFiles2 {
    private MoreFiles2() {
    }

    private static boolean isDirectory(SecureDirectoryStream<Path> dir, Path name, LinkOption ... options) throws IOException {
        return dir.getFileAttributeView(name, BasicFileAttributeView.class, options).readAttributes().isDirectory();
    }

    public static void deleteRecursively(Path path, RecursiveDeleteOption ... options) throws IOException {
        Path parentPath = MoreFiles2.getParentPath(path);
        if (parentPath == null) {
            throw new FileSystemException(path.toString(), null, "can't delete recursively");
        }
        Collection<IOException> exceptions = null;
        try (DirectoryStream<Path> parent = Files.newDirectoryStream(parentPath);){
            exceptions = parent instanceof SecureDirectoryStream ? MoreFiles2.deleteRecursivelySecure((SecureDirectoryStream)parent, parentPath, path.getFileName()) : MoreFiles2.deleteRecursivelyInsecure(path, true);
        }
        catch (IOException e) {
            if (exceptions == null) {
                throw e;
            }
            exceptions.add(e);
        }
        if (exceptions != null) {
            MoreFiles2.throwDeleteFailed(path, exceptions);
        }
    }

    public static void deleteRecursively(File dir, RecursiveDeleteOption ... options) throws IOException {
        MoreFiles2.deleteRecursively(dir.toPath(), new RecursiveDeleteOption[0]);
    }

    public static void deleteDirectoryContents(Path path, RecursiveDeleteOption ... options) throws IOException {
        Collection<IOException> exceptions = null;
        try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(path);){
            if (stream2 instanceof SecureDirectoryStream) {
                SecureDirectoryStream sds = (SecureDirectoryStream)stream2;
                exceptions = MoreFiles2.deleteDirectoryContentsSecure(sds, path);
            } else {
                exceptions = MoreFiles2.deleteRecursivelyInsecure(path, false);
            }
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException e) {
            if (exceptions == null) {
                throw e;
            }
            exceptions.add(e);
        }
        if (exceptions != null) {
            MoreFiles2.throwDeleteFailed(path, exceptions);
        }
    }

    private static @Nullable Collection<IOException> deleteRecursivelySecure(SecureDirectoryStream<Path> dir, Path dirPath, Path path) {
        Collection<IOException> exceptions = null;
        try {
            if (MoreFiles2.isDirectory(dir, path, LinkOption.NOFOLLOW_LINKS)) {
                Path childPath = dirPath.resolve(path);
                try (SecureDirectoryStream<Path> childDir = dir.newDirectoryStream(path, LinkOption.NOFOLLOW_LINKS);){
                    exceptions = MoreFiles2.deleteDirectoryContentsSecure(childDir, childPath);
                }
                if (exceptions == null) {
                    try {
                        dir.deleteDirectory(path);
                    }
                    catch (DirectoryNotEmptyException e) {
                        throw new IOException("Dir contents: " + String.valueOf(MoreFiles.listFiles((Path)childPath)), e);
                    }
                }
            } else {
                dir.deleteFile(path);
            }
            return exceptions;
        }
        catch (NoSuchFileException childPath) {
        }
        catch (IOException e) {
            MoreFiles2.addException(exceptions, e);
        }
        return exceptions;
    }

    private static @Nullable Collection<IOException> deleteDirectoryContentsSecure(SecureDirectoryStream<Path> dir, Path dirPath) {
        Collection<IOException> exceptions = null;
        try {
            for (Path path : dir) {
                exceptions = MoreFiles2.concat(exceptions, MoreFiles2.deleteRecursivelySecure(dir, dirPath, path.getFileName()));
            }
            return exceptions;
        }
        catch (DirectoryIteratorException e) {
            return MoreFiles2.addException(exceptions, e.getCause());
        }
    }

    private static @Nullable Collection<IOException> deleteRecursivelyInsecure(final Path path, final boolean deleteBaseDirectory) {
        final ArrayList<IOException> exceptions = new ArrayList<IOException>();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        Files.deleteIfExists(file);
                    }
                    catch (IOException e) {
                        MoreFiles2.addException(exceptions, e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException traversalException) {
                    if (traversalException != null) {
                        MoreFiles2.addException(exceptions, traversalException);
                    } else if (deleteBaseDirectory || !path.equals(dir)) {
                        try {
                            Files.deleteIfExists(dir);
                        }
                        catch (IOException e) {
                            MoreFiles2.addException(exceptions, e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            MoreFiles2.addException(exceptions, e);
        }
        if (exceptions.isEmpty()) {
            return null;
        }
        return exceptions;
    }

    private static @Nullable Path getParentPath(Path path) {
        Path parent = path.getParent();
        if (parent != null) {
            return parent;
        }
        if (path.getNameCount() == 0) {
            return null;
        }
        return path.getFileSystem().getPath(".", new String[0]);
    }

    private static Collection<IOException> addException(@Nullable Collection<IOException> exceptions, IOException e) {
        if (exceptions == null) {
            exceptions = new ArrayList<IOException>();
        }
        exceptions.add(e);
        return exceptions;
    }

    private static @Nullable Collection<IOException> concat(@Nullable Collection<IOException> exceptions, @Nullable Collection<IOException> other) {
        if (exceptions == null) {
            return other;
        }
        if (other != null) {
            exceptions.addAll(other);
        }
        return exceptions;
    }

    private static void throwDeleteFailed(Path path, Collection<IOException> exceptions) throws FileSystemException {
        FileSystemException deleteFailed = new FileSystemException(path.toString(), null, "failed to delete one or more files; see suppressed exceptions for details");
        for (IOException e : exceptions) {
            deleteFailed.addSuppressed(e);
        }
        throw deleteFailed;
    }
}

