/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import java.io.Flushable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Flusher {
    private static final Logger LOGGER = LoggerFactory.getLogger(Flusher.class);
    protected final Flushable mFlushable;

    private Flusher(Flushable theFlushable) {
        this.mFlushable = theFlushable;
    }

    protected void doFlush() {
        try {
            this.mFlushable.flush();
        }
        catch (Exception e) {
            LOGGER.warn("Error while flushing contents of " + String.valueOf(this.mFlushable), (Throwable)e);
        }
    }

    public abstract void run();

    public static Flusher sync(Flushable theFlushable) {
        return new SynchronousFlusher(theFlushable);
    }

    public static Flusher async(Flushable theFlushable, ExecutorService theExecutorService) {
        return new AsynchronousFlusher(theFlushable, theExecutorService);
    }

    private static class SynchronousFlusher
    extends Flusher {
        public SynchronousFlusher(Flushable theTask) {
            super(theTask);
        }

        @Override
        public void run() {
            this.doFlush();
        }
    }

    private static class AsynchronousFlusher
    extends Flusher {
        protected final Callable<Void> mFlushTask;
        protected final ExecutorService mExecutorService;
        protected Future<Void> mFuture;
        protected AtomicBoolean mContinueFlush = new AtomicBoolean(false);

        private AsynchronousFlusher(Flushable theFlushable, ExecutorService theService) {
            super(theFlushable);
            this.mExecutorService = theService;
            this.mFlushTask = new Callable<Void>(){

                @Override
                public Void call() {
                    do {
                        mContinueFlush.set(false);
                        this.doFlush();
                    } while (mContinueFlush.get());
                    return null;
                }
            };
        }

        @Override
        public void run() {
            try {
                if (this.mFuture != null && !this.mFuture.isDone()) {
                    this.mContinueFlush.set(true);
                } else {
                    this.mFuture = this.mExecutorService.submit(this.mFlushTask);
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }
}

