/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.OS;
import com.complexible.common.base.Dates;
import com.complexible.common.base.Exceptions;
import com.complexible.common.io.MoreFiles2;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public final class Files2 {
    private Files2() {
        throw new AssertionError();
    }

    public static Path tmpDir() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public static Path createTempDir() {
        int TEMP_DIR_ATTEMPTS = 10;
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < TEMP_DIR_ATTEMPTS; ++counter) {
            try {
                return Files.createTempDirectory(baseName + counter, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new IllegalStateException("Failed to create directory within " + TEMP_DIR_ATTEMPTS + " attempts (tried " + baseName + "0 to " + baseName + (TEMP_DIR_ATTEMPTS - 1) + ")");
    }

    public static void deleteRecursively(Path file) throws IOException {
        if (Files.notExists(file, new LinkOption[0])) {
            return;
        }
        MoreFiles2.deleteRecursively(file, RecursiveDeleteOption.ALLOW_INSECURE);
    }

    public static void deleteDirectoryContents(Path dir) throws IOException {
        MoreFiles2.deleteDirectoryContents(dir, RecursiveDeleteOption.ALLOW_INSECURE);
    }

    public static List<Path> listFilesRecursively(Path theDirectory, @Nonnull DirectoryStream.Filter<? super Path> theFilter) throws IOException {
        ArrayList<Path> aList = new ArrayList<Path>();
        if (!Files.isDirectory(theDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected a directory, not a file: " + String.valueOf(theDirectory));
        }
        if (!Files.isReadable(theDirectory)) {
            return Collections.emptyList();
        }
        ImmutableList<Path> aFileList = Files2.listFiles(theDirectory, (? super Path f) -> Files.isDirectory(f, new LinkOption[0]) || theFilter.accept((Path)f));
        for (Path aFile : aFileList) {
            if (Files.isDirectory(aFile, new LinkOption[0])) {
                aList.addAll(Files2.listFilesRecursively(aFile, theFilter));
                continue;
            }
            aList.add(aFile);
        }
        return aList;
    }

    public static ImmutableList<Path> listFiles(Path theDirectory, DirectoryStream.Filter<? super Path> theFilter) throws IOException {
        ImmutableList immutableList;
        block8: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(theDirectory, theFilter);
            try {
                immutableList = ImmutableList.copyOf(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryIteratorException e) {
                    throw e.getCause();
                }
            }
            stream.close();
        }
        return immutableList;
    }

    public static ImmutableList<Path> listFiles(Path dir, String glob) throws IOException {
        ImmutableList immutableList;
        block8: {
            DirectoryStream<Path> files = Files.newDirectoryStream(dir, glob);
            try {
                immutableList = ImmutableList.copyOf(files);
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryIteratorException e) {
                    throw e.getCause();
                }
            }
            files.close();
        }
        return immutableList;
    }

    public static long numFilesInDirectoryByPattern(Path directory, String globPattern) throws IOException {
        long l;
        block9: {
            DirectoryStream<Path> files = Files.newDirectoryStream(directory, globPattern);
            try {
                l = StreamSupport.stream(files.spliterator(), false).count();
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NotDirectoryException e) {
                    throw new IllegalArgumentException("Not a directory: " + String.valueOf(directory), e);
                }
                catch (DirectoryIteratorException e) {
                    throw e.getCause();
                }
            }
            files.close();
        }
        return l;
    }

    public static void rotate(Path srcFile, Path dstFile, boolean keepBackupFiles) throws IOException {
        if (dstFile.toFile().exists()) {
            if (keepBackupFiles) {
                Files2.rotate(dstFile);
            } else {
                Files.delete(dstFile);
            }
        }
        Files2.movePersistently(srcFile, dstFile);
    }

    private static void rotate(Path theFile) throws IOException {
        String dateStr = Dates.date(new Date(Files.getLastModifiedTime(theFile, new LinkOption[0]).toMillis()));
        String fileName = theFile.getFileName().toString();
        Path rotatedFile = null;
        boolean fileExists = true;
        for (int counter = 0; fileExists && counter < Integer.MAX_VALUE; ++counter) {
            rotatedFile = theFile.getParent().resolve(String.format("%s.%s.%04d", fileName, dateStr, counter));
            fileExists = Files.exists(rotatedFile, new LinkOption[0]);
        }
        Files2.movePersistently(theFile, rotatedFile);
    }

    public static void movePersistently(Path from, Path to) throws IOException {
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        from = from.toAbsolutePath();
        to = to.toAbsolutePath();
        Preconditions.checkArgument((!from.equals(to) ? 1 : 0) != 0, (String)"Source %s and destination %s must be different", (Object)from, (Object)to);
        Path directory = from.getParent();
        Preconditions.checkArgument((boolean)directory.equals(to.getParent()), (String)"Source %s and destination %s must be in the same directory", (Object)from, (Object)to);
        try {
            Files.move(from, to, StandardCopyOption.ATOMIC_MOVE);
            Files2.persist(directory, true);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.copy(from, to, new CopyOption[0]);
            Files2.persist(to, false);
            Files2.persist(directory, true);
            Files.delete(from);
        }
    }

    public static void persist(Path fileOrDirectory, boolean isDirectory) throws IOException {
        if (isDirectory && OS.isWindows()) {
            return;
        }
        StandardOpenOption openOption = isDirectory ? StandardOpenOption.READ : StandardOpenOption.WRITE;
        try (FileChannel ch = FileChannel.open(fileOrDirectory, openOption);){
            ch.force(false);
        }
    }

    public static void copyDirectory(Path theSource, Path theDest) throws IOException {
        if (Files.isDirectory(theSource, new LinkOption[0])) {
            if (!Files.exists(theDest, new LinkOption[0])) {
                Files.createDirectories(theDest, new FileAttribute[0]);
            }
            try (Stream<Path> children = Files.list(theSource);){
                children.forEach(aChild -> {
                    try {
                        Files2.copyDirectory(aChild, theDest.resolve(theSource.relativize((Path)aChild)));
                    }
                    catch (IOException theE) {
                        throw Exceptions.rethrowChecked(theE);
                    }
                });
            }
        } else {
            Files.copy(theSource, theDest, new CopyOption[0]);
        }
    }

    public static void moveDirectory(Path theSource, Path theDest) throws IOException {
        try {
            Files.move(theSource, theDest, new CopyOption[0]);
        }
        catch (IOException theE) {
            Files2.deleteRecursively(theDest);
            Files2.copyDirectory(theSource, theDest);
            Files2.deleteRecursively(theSource);
        }
    }

    public static void loadProperties(Properties properties, Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            properties.load(in);
        }
    }

    public static Properties loadProperties(Path file) throws IOException {
        Properties p = new Properties();
        Files2.loadProperties(p, file);
        return p;
    }

    public static boolean isDirectoryEmpty(Path dir) throws IOException {
        try (Stream<Path> files = Files.list(dir);){
            boolean bl = !files.findAny().isPresent();
            return bl;
        }
    }

    public static String toString(Path thePath, Charset theCharset) throws IOException {
        return new String(Files.readAllBytes(thePath), theCharset);
    }

    public static String toString(Path thePath) throws IOException {
        return Files2.toString(thePath, StandardCharsets.UTF_8);
    }

    public static void writeString(Path thePath, String theContent) throws IOException {
        Files.write(thePath, theContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static Path withJarFileSystem(String thePath, Class<?> theClass) {
        try {
            String aUri = Resources.getResource(theClass, (String)thePath).toURI().toString();
            String[] aSplit = aUri.split("!");
            FileSystem aFs = FileSystems.newFileSystem(URI.create(aSplit[0]), Maps.newHashMap());
            return aFs.getPath(aSplit[1], new String[0]);
        }
        catch (IOException | URISyntaxException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static Path classPath(String thePath) {
        try {
            return Paths.get(Files2.class.getResource(thePath).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static long size(Path thePath) {
        try {
            return Files.size(thePath);
        }
        catch (IOException e) {
            return -1L;
        }
    }
}

