/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DataInputToInputStreamAdapter
extends InputStream {
    private static final int SKIP_BULK = 0x40000000;
    private final DataInput mInput;

    private DataInputToInputStreamAdapter(DataInput theInput) {
        this.mInput = theInput;
    }

    public static InputStream create(DataInput theDataInput) {
        return theDataInput instanceof InputStream ? (InputStream)((Object)theDataInput) : new DataInputToInputStreamAdapter(theDataInput);
    }

    @Override
    public int read() throws IOException {
        try {
            return Byte.toUnsignedInt(this.mInput.readByte());
        }
        catch (EOFException e) {
            return -1;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long totalSkipped = 0L;
        while (n > 0L) {
            int toSkip = (int)Math.min(n, 0x40000000L);
            int skipped = this.mInput.skipBytes(toSkip);
            totalSkipped += (long)skipped;
            if (skipped < toSkip) break;
            n -= (long)toSkip;
        }
        return totalSkipped;
    }
}

