/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.io.ByteWriter;
import com.complexible.common.io.impl.AbstractByteWriter;
import java.io.IOException;
import java.io.OutputStream;

public final class ByteWriters {
    private ByteWriters() {
        throw new AssertionError();
    }

    public static ByteWriter asByteWriter(OutputStream theOutputStream) {
        return new OutputStreamByteWriter(theOutputStream);
    }

    public static ByteWriter nullWriter() {
        return new AbstractByteWriter(){

            @Override
            public long length() throws IOException {
                return 0L;
            }

            @Override
            public long getPosition() throws IOException {
                return 0L;
            }

            @Override
            public void setPosition(long thePosition) throws IOException {
            }

            @Override
            public void writeByte(byte theValue) throws IOException {
            }
        };
    }

    private static final class OutputStreamByteWriter
    extends AbstractByteWriter {
        private final OutputStream mStream;
        private long mPosition = 0L;

        private OutputStreamByteWriter(OutputStream theStream) {
            this.mStream = theStream;
        }

        @Override
        public long getPosition() throws IOException {
            return this.mPosition;
        }

        @Override
        public long length() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPosition(long thePosition) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeByte(byte theValue) throws IOException {
            ++this.mPosition;
            this.mStream.write(theValue);
        }

        @Override
        public void write(byte[] theData) throws IOException {
            this.mPosition += (long)theData.length;
            this.mStream.write(theData);
        }

        @Override
        public void write(byte[] theData, int theOffset, int theLength) throws IOException {
            this.mPosition += (long)theLength;
            this.mStream.write(theData, theOffset, theLength);
        }
    }
}

