/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public final class ByteSources {
    private ByteSources() {
        throw new AssertionError();
    }

    public static ByteSource gzip(ByteSource theByteSource) {
        return new GZIPByteSource(theByteSource);
    }

    private static final class GZIPByteSource
    extends ByteSource {
        private final ByteSource mSource;

        private GZIPByteSource(ByteSource theSource) {
            this.mSource = theSource;
        }

        public String toString() {
            return "GZIPByteSource.create(" + this.mSource.toString() + ")";
        }

        public InputStream openStream() throws IOException {
            return new GZIPInputStream(this.mSource.openStream());
        }
    }
}

