/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.io.StringIO;
import com.google.common.io.ByteArrayDataOutput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public final class ByteOutput
implements ByteArrayDataOutput {
    public byte[] data;
    public int length;

    public ByteOutput(int size) {
        this(new byte[size], 0);
    }

    public ByteOutput(byte[] data) {
        this(data, data.length);
    }

    public ByteOutput(byte[] data, int length) {
        this.data = data;
        this.length = length;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.data, this.length);
    }

    public void reset() {
        this.length = 0;
    }

    void ensureCapacity(int capacity) {
        if (capacity > this.data.length) {
            this.data = Arrays.copyOf(this.data, Math.max(this.data.length << 1, capacity));
        }
    }

    public void write(int b) {
        this.ensureCapacity(this.length + 1);
        this.data[this.length++] = (byte)b;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        this.ensureCapacity(this.length + len);
        System.arraycopy(b, off, this.data, this.length, len);
        this.length += len;
    }

    public final void writeBoolean(boolean v) {
        this.writeByte(v ? 1 : 0);
    }

    public final void writeByte(int v) {
        this.ensureCapacity(this.length + 1);
        this.data[this.length++] = (byte)v;
    }

    public final void writeShort(int v) {
        this.ensureCapacity(this.length + 2);
        this.data[this.length++] = (byte)(v >>> 8 & 0xFF);
        this.data[this.length++] = (byte)(v >>> 0 & 0xFF);
    }

    public final void writeChar(int v) {
        this.ensureCapacity(this.length + 2);
        this.data[this.length++] = (byte)(v >>> 8 & 0xFF);
        this.data[this.length++] = (byte)(v >>> 0 & 0xFF);
    }

    public final void writeInt(int v) {
        this.ensureCapacity(this.length + 4);
        this.data[this.length++] = (byte)(v >>> 24 & 0xFF);
        this.data[this.length++] = (byte)(v >>> 16 & 0xFF);
        this.data[this.length++] = (byte)(v >>> 8 & 0xFF);
        this.data[this.length++] = (byte)(v >>> 0 & 0xFF);
    }

    public final void writeLong(long v) {
        this.ensureCapacity(this.length + 8);
        this.data[this.length++] = (byte)(v >>> 56 & 0xFFL);
        this.data[this.length++] = (byte)(v >>> 48 & 0xFFL);
        this.data[this.length++] = (byte)(v >>> 40 & 0xFFL);
        this.data[this.length++] = (byte)(v >>> 32 & 0xFFL);
        this.data[this.length++] = (byte)(v >>> 24 & 0xFFL);
        this.data[this.length++] = (byte)(v >>> 16 & 0xFFL);
        this.data[this.length++] = (byte)(v >>> 8 & 0xFFL);
        this.data[this.length++] = (byte)(v >>> 0 & 0xFFL);
    }

    public final void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeBytes(String s) {
        int len = s.length();
        this.ensureCapacity(this.length + len);
        for (int i = 0; i < len; ++i) {
            this.data[this.length++] = (byte)s.charAt(i);
        }
    }

    public final void writeChars(String s) {
        int len = s.length();
        this.ensureCapacity(this.length + 2 * len);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.data[this.length++] = (byte)(v >>> 8 & 0xFF);
            this.data[this.length++] = (byte)(v >>> 0 & 0xFF);
        }
    }

    public final void writeUTF(String str) {
        try {
            StringIO.INSTANCE.write(str, (DataOutput)((Object)this));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

