/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.base.Numbers;
import com.complexible.common.io.SegmentedFile;
import com.complexible.common.io.SegmentedFileBuilder;
import com.complexible.common.nio.ByteBuffers;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSegmentedFile
implements SegmentedFile {
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractSegmentedFile.class);
    protected final int segmentSize;
    protected final int fileOffset;
    private final FileChannel.MapMode mapMode;
    private FileChannel channel;
    private int maxSegment;
    private boolean sliceBuffers;
    private ThreadLocal<Segment> lastAccessedSegment;
    private long lastAccessHits;
    private long lastAccessMisses;

    public AbstractSegmentedFile(SegmentedFileBuilder theBuilder) {
        this.channel = theBuilder.file();
        this.segmentSize = theBuilder.segmentSize();
        this.fileOffset = theBuilder.fileOffset();
        this.maxSegment = 0;
        this.sliceBuffers = theBuilder.sliceBuffers();
        this.mapMode = theBuilder.mapMode();
        if (theBuilder.cacheLastAccessedSegment()) {
            this.lastAccessedSegment = new ThreadLocal<Segment>(this){

                @Override
                protected Segment initialValue() {
                    return new Segment();
                }
            };
        }
    }

    @Override
    public ByteBuffer getBuffer(long offset) throws IOException {
        return this.getBuffer(offset, -1);
    }

    protected abstract MappedByteBuffer getSegment(int var1) throws IOException;

    protected MappedByteBuffer mapSegment(int segmentIndex) throws IOException {
        this.maxSegment = Math.max(segmentIndex, this.maxSegment);
        long segmentStart = (long)segmentIndex * (long)this.segmentSize + (long)this.fileOffset;
        long mapLength = Math.min((long)this.segmentSize, this.channel.size() - segmentStart);
        return ByteBuffers.map(this.channel, this.mapMode, segmentStart, mapLength, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public ByteBuffer getBuffer(long offset, int length) throws IOException {
        ByteBuffer segment;
        int segmentIndex = (int)((offset -= (long)this.fileOffset) / (long)this.segmentSize);
        int segmentOffset = (int)(offset % (long)this.segmentSize);
        if (this.lastAccessedSegment != null) {
            Segment lastAccessed = this.lastAccessedSegment.get();
            if (segmentIndex == lastAccessed.index) {
                segment = lastAccessed.buffer;
                segment.limit(this.segmentSize);
                ++this.lastAccessHits;
            } else {
                segment = ByteBuffers.duplicate(this.getSegment(segmentIndex));
                lastAccessed.update(segmentIndex, segment);
                ++this.lastAccessMisses;
            }
        } else {
            segment = ByteBuffers.duplicate(this.getSegment(segmentIndex));
        }
        int segmentLimit = length == -1 ? segment.capacity() : segmentOffset + length;
        segment.position(segmentOffset).limit(segmentLimit);
        return this.sliceBuffers ? ByteBuffers.slice(segment) : segment;
    }

    protected abstract Iterable<MappedByteBuffer> segments();

    @Override
    public int getSegmentSize() {
        return this.segmentSize;
    }

    @Override
    public int getMaxSegment() {
        return this.maxSegment;
    }

    @Override
    public long length() {
        return ((long)this.maxSegment + 1L) * (long)this.segmentSize;
    }

    @Override
    public String debugString() {
        Object str = String.format("Max segment: %,d", this.maxSegment);
        if (this.lastAccessedSegment != null) {
            str = (String)str + " (Last access - H/M: " + Numbers.readable(this.lastAccessHits) + "/" + Numbers.readable(this.lastAccessMisses) + ")";
        }
        return str;
    }

    @Override
    public synchronized void flush() {
        if (this.channel == null) {
            return;
        }
        int totalCount = 0;
        int errorCount = 0;
        Exception ex = null;
        for (MappedByteBuffer segment : this.segments()) {
            ++totalCount;
            try {
                segment.force();
            }
            catch (Exception e) {
                ++errorCount;
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            LOGGER.warn("Error flushing " + errorCount + " of " + totalCount + " memory-mapped file segment(s)", ex);
        }
    }

    @Override
    public synchronized void close() {
        try {
            Closeables.close((Closeable)this.channel, (boolean)true);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Should not happen");
        }
        this.channel = null;
    }

    private static class Segment {
        private int index = -1;
        private ByteBuffer buffer = null;

        private Segment() {
        }

        private void update(int index, ByteBuffer buffer) {
            this.index = index;
            this.buffer = buffer;
        }
    }
}

