/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.inject;

import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import java.util.Optional;
import java.util.function.Supplier;

public final class OptionalConstructorParam<T>
implements Supplier<T> {
    @Inject(optional=true)
    private T value;

    @Inject
    public OptionalConstructorParam() {
    }

    public OptionalConstructorParam(T theValue) {
        this.value = theValue;
    }

    @Override
    public T get() {
        return this.value;
    }

    public T or(T theDefault) {
        return this.value == null ? theDefault : this.value;
    }

    public T or(Supplier<? extends T> theDefault) {
        return this.or(theDefault.get());
    }

    public T orNull() {
        return this.or((T)null);
    }

    public Optional<T> asOptional() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.value).toString();
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public static <T> OptionalConstructorParam<T> create(T theValue) {
        return new OptionalConstructorParam<T>(theValue);
    }
}

