/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.inject;

import com.complexible.common.util.ServiceLoaders;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Errors;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Message;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class Injectors {
    private Injectors() {
        throw new AssertionError();
    }

    public static <T> Iterable<? extends T> instancesOf(Injector theInjector, Class<T> theClass) {
        return Iterables.transform(Injectors.providers(theInjector.findBindingsByType(TypeLiteral.get(theClass))), Provider::get);
    }

    public static <T> Iterable<Provider<T>> providers(Injector theInjector, Class<T> theClass) {
        return Injectors.providers(theInjector.findBindingsByType(TypeLiteral.get(theClass)));
    }

    public static <T> Iterable<Provider<T>> providers(List<Binding<T>> theBindingsByType) {
        return Iterables.transform(theBindingsByType, Binding::getProvider);
    }

    public static void prettyPrintErrors(Iterable<Message> theErrors) {
        if (theErrors == null) {
            return;
        }
        HashMultimap aMap = HashMultimap.create();
        for (Message message : theErrors) {
            if (message.getMessage() == null) continue;
            aMap.put((Object)message.getMessage(), (Object)message);
        }
        for (Map.Entry entry : aMap.asMap().entrySet()) {
            System.err.println(" *\t" + (String)entry.getKey());
            Throwable aCause = null;
            HashSet aErrors = Sets.newHashSet();
            for (Message aMsg : (Collection)entry.getValue()) {
                if (aCause == null) {
                    aCause = aMsg.getCause();
                }
                for (Object aSrc : aMsg.getSources()) {
                    Object aError = Errors.convert(aSrc);
                    if (aError == null) continue;
                    if (aError instanceof Dependency) {
                        Dependency aDep = (Dependency)aError;
                        if (aDep.getInjectionPoint() == null) continue;
                        aErrors.add(aDep.getInjectionPoint().toString());
                        continue;
                    }
                    if (aError instanceof StackTraceElement) continue;
                    aErrors.add(aError.toString());
                }
            }
            for (Object aError : aErrors) {
                System.err.println("\t\t" + String.valueOf(aError));
            }
            if (aCause == null) continue;
            System.err.println("  \tCaused by:");
            aCause.printStackTrace();
        }
    }

    public static <T> void install(Binder theBinder, Class<T> theClass) {
        Multibinder aBinder = Multibinder.newSetBinder((Binder)theBinder, theClass);
        for (Class<T> aClass : ServiceLoaders.classesOf(theClass)) {
            aBinder.addBinding().to(aClass);
        }
    }
}

