/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.hash;

import com.complexible.common.io.ByteReader;
import java.io.IOException;

public final class JenkinsHash {
    private JenkinsHash() {
    }

    public static int hash(ByteReader input) throws IOException {
        return JenkinsHash.hash(input, (int)input.length());
    }

    public static int hash(ByteReader theInput, int theLength) throws IOException {
        int aLength;
        int c;
        int pc = 0;
        int pb = 0;
        int b = c = -559038737 + theLength + pc;
        int a = c;
        c += pb;
        for (aLength = theLength; aLength > 12; aLength -= 12) {
            a += theInput.readInt();
            a -= (c += theInput.readInt());
            a ^= JenkinsHash.rot(c, 4);
            b -= a;
            b ^= JenkinsHash.rot(a, 6);
            a += (c += (b += theInput.readInt()));
            c -= b;
            c ^= JenkinsHash.rot(b, 8);
            b += a;
            a -= c;
            a ^= JenkinsHash.rot(c, 16);
            c += b;
            b -= a;
            b ^= JenkinsHash.rot(a, 19);
            a += c;
            c -= b;
            c ^= JenkinsHash.rot(b, 4);
            b += a;
        }
        switch (aLength) {
            case 12: {
                c += theInput.readByte() << 24;
            }
            case 11: {
                c += theInput.readByte() << 16;
            }
            case 10: {
                c += theInput.readByte() << 8;
            }
            case 9: {
                c += theInput.readByte();
            }
            case 8: {
                b += theInput.readByte() << 24;
            }
            case 7: {
                b += theInput.readByte() << 16;
            }
            case 6: {
                b += theInput.readByte() << 8;
            }
            case 5: {
                b += theInput.readByte();
            }
            case 4: {
                a += theInput.readByte() << 24;
            }
            case 3: {
                a += theInput.readByte() << 16;
            }
            case 2: {
                a += theInput.readByte() << 8;
            }
            case 1: {
                a += theInput.readByte();
                break;
            }
            case 0: {
                return c;
            }
        }
        c ^= b;
        a ^= (c -= JenkinsHash.rot(b, 14));
        b ^= (a -= JenkinsHash.rot(c, 11));
        c ^= (b -= JenkinsHash.rot(a, 25));
        a ^= (c -= JenkinsHash.rot(b, 16));
        b ^= (a -= JenkinsHash.rot(c, 4));
        c ^= (b -= JenkinsHash.rot(a, 14));
        return c -= JenkinsHash.rot(b, 24);
    }

    private static int rot(int x, int distance) {
        return x << distance | x >>> 32 - distance;
    }
}

