/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.dataexporter;

import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.CellDetails;
import com.complexible.common.dataexporter.FormattedColumn;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.WordUtils;

public class WordWrapStringColumn
extends FormattedColumn {
    private static final String NEWLINE = SystemUtils.LINE_SEPARATOR;

    public WordWrapStringColumn(String name) {
        this(name, AlignType.TOP_LEFT);
    }

    public WordWrapStringColumn(String name, AlignType align) {
        super(name, "%s", align);
    }

    public List<String> align(CellDetails cellDetails, String cellValue, String filler) {
        return this.alignLines(cellDetails, cellValue);
    }

    @Override
    public int getMaxRowHeight(CellDetails cellDetails) {
        String cellValue = this.format(cellDetails);
        List<String> lines = this.splitToLines(cellDetails, cellValue);
        return lines.size();
    }

    private List<String> alignLines(CellDetails cellDetails, String cellValue) {
        List<String> lines = this.splitToLines(cellDetails, cellValue);
        int width = cellDetails.getColumn().getWidth();
        int height = cellDetails.getRowHeight();
        String emptyLine = Strings.repeat((String)" ", (int)width);
        for (int i = lines.size(); i < height; ++i) {
            lines.add(emptyLine);
        }
        return lines;
    }

    private List<String> splitToLines(CellDetails cellDetails, String cellValue) {
        ArrayList lines = Lists.newArrayList();
        int width = cellDetails.getColumn().getWidth();
        for (String line : Splitter.on((String)NEWLINE).split((CharSequence)cellValue)) {
            if (line.length() < width) {
                lines.add(this.padLine(line, width));
                continue;
            }
            String wrappedLine = WordUtils.wrap((String)line, (int)width, (String)SystemUtils.LINE_SEPARATOR, (boolean)true);
            for (String splitLine : Splitter.on((String)NEWLINE).splitToList((CharSequence)wrappedLine)) {
                lines.add(this.padLine(splitLine, width));
            }
        }
        return lines;
    }

    private String padLine(String line, int width) {
        AlignType alignType = this.getAlign();
        if (alignType.isLeft()) {
            return StringUtils.rightPad((String)line, (int)width);
        }
        if (alignType.isRight()) {
            return StringUtils.leftPad((String)line, (int)width);
        }
        return StringUtils.center((String)line, (int)width);
    }
}

