/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.dataexporter;

import com.brsanthu.dataexporter.DataExporter;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.Column;
import com.brsanthu.dataexporter.model.Table;
import com.complexible.common.dataexporter.Columns;
import com.complexible.common.dataexporter.LogOutputter;
import com.complexible.common.dataexporter.MergedColumn;
import com.complexible.common.dataexporter.TableExporter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TextTabularOutput
implements LogOutputter {
    private final DataExporter mExporter;
    private final ImmutableList<Column> mColumns;
    private final ImmutableList<MergedColumn> mMergedColumns;
    private final List<Object[]> mPrefetchedRows;
    private int mMinColWidth = 5;
    private int mMaxColWidth = 80;
    private int mPrefetchLimit = 1000;
    private long mResultCount;

    public TextTabularOutput(OutputStream theOut, String ... theColNames) {
        this(theOut, (Iterable<Column>)Lists.transform(Arrays.asList(theColNames), Columns::string));
    }

    public TextTabularOutput(OutputStream theOut, Column ... theColumns) {
        this(theOut, Arrays.asList(theColumns));
    }

    public TextTabularOutput(OutputStream theOut, Iterable<Column> theColumns) {
        this(new TableExporter(theOut), theColumns);
    }

    public TextTabularOutput(DataExporter theExporter, Iterable<Column> theColumns) {
        this.mExporter = theExporter;
        ImmutableList.Builder aColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder aMergedColumnsBuilder = ImmutableList.builder();
        boolean hasMergedColumns = false;
        for (Column aColumn : theColumns) {
            if (aColumn instanceof MergedColumn) {
                MergedColumn aMergedColumn = (MergedColumn)aColumn;
                aMergedColumnsBuilder.add((Object)aMergedColumn);
                aColumnsBuilder.addAll(aMergedColumn.getColumns());
                hasMergedColumns = true;
                continue;
            }
            aMergedColumnsBuilder.add((Object)Columns.merge("", aColumn));
            aColumnsBuilder.add((Object)aColumn);
        }
        Preconditions.checkArgument((!hasMergedColumns || theExporter instanceof TableExporter ? 1 : 0) != 0, (Object)"Merged columns can only be used with table exporter");
        this.mColumns = aColumnsBuilder.build();
        this.mMergedColumns = hasMergedColumns ? aMergedColumnsBuilder.build() : ImmutableList.of();
        this.mColumns.forEach(xva$0 -> this.mExporter.addColumns(new Column[]{xva$0}));
        this.mPrefetchedRows = Lists.newArrayList();
    }

    @Override
    public long output() {
        if (this.mResultCount <= (long)this.mPrefetchLimit) {
            this.exportPretechedResults();
        }
        this.mExporter.finishExporting();
        return this.mResultCount;
    }

    private void prefetchResult(Object ... theRow) {
        this.mPrefetchedRows.add(Arrays.copyOf(theRow, theRow.length));
        CellDetails cell = new CellDetails();
        for (int i = 0; i < theRow.length; ++i) {
            if (theRow[i] == null) continue;
            cell.setColumn((Column)this.mColumns.get(i));
            cell.setCellValue(theRow[i]);
            int aColWidth = ((Column)this.mColumns.get(i)).format(cell).length();
            Columns.ensureWidth((Column)this.mColumns.get(i), Math.min(this.mMaxColWidth, aColWidth));
        }
    }

    private void printTopHeader() {
        if (!this.mMergedColumns.isEmpty()) {
            for (MergedColumn aMergedColumn : this.mMergedColumns) {
                aMergedColumn.adjustWidth();
            }
            TableExporter.FixedTextTableWriter aWriter = new TableExporter.FixedTextTableWriter(this, System.out){

                @Override
                public void printTopDownBorder() {
                }
            };
            Table aTable = new Table();
            aTable.setColumns(this.mMergedColumns);
            aWriter.writeHeader(aTable);
        }
    }

    private void exportPretechedResults() {
        for (Column aColumn : this.mColumns) {
            Columns.ensureWidth(aColumn, this.mMinColWidth);
        }
        this.printTopHeader();
        this.mExporter.startExporting();
        for (Object[] aRow : this.mPrefetchedRows) {
            this.mExporter.addRow(aRow);
        }
    }

    @Override
    public void addRow(Object ... theRow) {
        if (theRow.length != this.mColumns.size()) {
            throw new IllegalArgumentException("Invalid number of columns: " + theRow.length);
        }
        if (this.mResultCount < (long)this.mPrefetchLimit) {
            this.prefetchResult(theRow);
        } else {
            if (this.mResultCount == (long)this.mPrefetchLimit) {
                this.exportPretechedResults();
            }
            this.mExporter.addRow(theRow);
        }
        ++this.mResultCount;
    }

    public int getPrefetchLimit() {
        return this.mPrefetchLimit;
    }

    @Override
    public void setPrefetchLimit(int thePrefetchLimit) {
        this.mPrefetchLimit = thePrefetchLimit;
    }

    public int getMinColWidth() {
        return this.mMinColWidth;
    }

    public void setMinColWidth(int theMinColWidth) {
        this.mMinColWidth = theMinColWidth;
    }

    public int getMaxColWidth() {
        return this.mMaxColWidth;
    }

    public void setMaxColWidth(int theMaxColWidth) {
        this.mMaxColWidth = theMaxColWidth;
    }

    public Column getColumn(int index) {
        return (Column)this.mColumns.get(index);
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.mColumns);
    }
}

