/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.dataexporter;

import com.brsanthu.dataexporter.DataExporter;
import com.brsanthu.dataexporter.DataWriter;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.Column;
import com.brsanthu.dataexporter.model.RowDetails;
import com.brsanthu.dataexporter.model.Table;
import com.brsanthu.dataexporter.output.texttable.TextTableExportOptions;
import com.brsanthu.dataexporter.output.texttable.TextTableExportStyle;
import com.brsanthu.dataexporter.output.texttable.TextTableWriter;
import java.io.OutputStream;
import java.util.List;

public class TableExporter
extends DataExporter {
    public TableExporter(OutputStream theOut) {
        super((DataWriter)new FixedTextTableWriter(theOut));
    }

    public TextTableExportOptions getOptions() {
        return (TextTableExportOptions)super.getOptions();
    }

    private static TextTableExportOptions createOptions() {
        TextTableExportOptions aTableOptions = new TextTableExportOptions();
        aTableOptions.setNullString(" ");
        aTableOptions.setStyle(TableExporter.createStyle());
        return aTableOptions;
    }

    private static TextTableExportStyle createStyle() {
        String aBorder = "-";
        String aIntersection = "+";
        String aDivider = "|";
        String aSpace = " ";
        String aLeftIntersection = aIntersection + aBorder;
        String aCenterIntersection = aBorder + aIntersection + aBorder;
        String aRightIntersection = aBorder + aIntersection;
        String aLeftDivider = aDivider + aSpace;
        String aCenterDivider = aSpace + aDivider + aSpace;
        String aRightDivider = aSpace + aDivider;
        TextTableExportStyle aStyle = new TextTableExportStyle(aCenterIntersection, aBorder, aBorder, aCenterDivider);
        aStyle.setTopLeftIntersection(aLeftIntersection);
        aStyle.setTopRightIntersection(aRightIntersection);
        aStyle.setTopLeftDivider(aLeftDivider);
        aStyle.setTopRightDivider(aRightDivider);
        aStyle.setTopDownLeftIntersection(aLeftIntersection);
        aStyle.setTopDownRightIntersection(aRightIntersection);
        aStyle.setCenterLeftDivider(aLeftDivider);
        aStyle.setCenterRightDivider(aRightDivider);
        aStyle.setBottomLeftIntersection(aLeftIntersection);
        aStyle.setBottomRightIntersection(aRightIntersection);
        return aStyle;
    }

    public static class FixedTextTableWriter
    extends TextTableWriter {
        private List<Column> mColumns;

        public FixedTextTableWriter(OutputStream out) {
            super(TableExporter.createOptions(), out);
        }

        protected void printTopBorder() {
            this.printLine(this.getStyle().getTopLeftIntersection(), this.getStyle().getTopLeftRightIntersection(), this.getStyle().getTopCenterIntersection(), this.getStyle().getTopRightLeftIntersection(), this.getStyle().getTopRightIntersection(), this.getStyle().getTopBorder());
        }

        public void printTopDownBorder() {
            this.printLine(this.getStyle().getTopDownLeftIntersection(), this.getStyle().getTopDownLeftRightIntersection(), this.getStyle().getTopDownCenterIntersection(), this.getStyle().getTopDownRightLeftIntersection(), this.getStyle().getTopDownRightIntersection(), this.getStyle().getTopDownBorder());
        }

        public void printBottomBorder() {
            this.printLine(this.getStyle().getBottomLeftIntersection(), this.getStyle().getBottomLeftRightIntersection(), this.getStyle().getBottomCenterIntersection(), this.getStyle().getBottomRightLeftIntersection(), this.getStyle().getBottomRightIntersection(), this.getStyle().getBottomBorder());
        }

        public void printHeaderCells(List<List<String>> headerLines) {
            this.printLine(this.getStyle().getTopLeftDivider(), this.getStyle().getTopLeftRightDivider(), this.getStyle().getTopCenterDivider(), this.getStyle().getTopRightLeftDivider(), this.getStyle().getTopRightDivider(), headerLines);
        }

        public int getMaxRowHeight(RowDetails rowDetails) {
            int height = 1;
            for (int columnIndex = 0; columnIndex < this.mColumns.size(); ++columnIndex) {
                CellDetails cellDetails = new CellDetails(rowDetails, columnIndex);
                Column column = this.mColumns.get(columnIndex);
                Object cellValue = column.isGeneratesOwnData() ? column.getCellValueGenerator().generateCellValue(cellDetails) : rowDetails.getRow().getCellValue(cellDetails);
                cellDetails.setCellValue(cellValue);
                height = Math.max(height, this.mColumns.get(columnIndex).getMaxRowHeight(cellDetails));
            }
            return height;
        }

        public void writeHeader(Table table) {
            this.mColumns = table.getColumns();
            super.writeHeader(table);
        }
    }
}

