/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.dataexporter;

import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.Column;
import com.complexible.common.dataexporter.FormattedColumn;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public class MergedColumn
extends FormattedColumn {
    private ImmutableList<Column> columns;

    public MergedColumn(String name, Iterable<Column> columns) {
        super(name, "%s", AlignType.TOP_CENTER);
        this.columns = ImmutableList.copyOf(columns);
        Preconditions.checkArgument((!this.columns.isEmpty() ? 1 : 0) != 0, (Object)"Merged columns cannot be empty");
    }

    public ImmutableList<Column> getColumns() {
        return this.columns;
    }

    public void adjustWidth() {
        int mergedColumnsWidth = this.columns.stream().mapToInt(Column::getWidth).sum() + 3 * (this.columns.size() - 1);
        if (mergedColumnsWidth < this.getWidth()) {
            Column lastColumn = (Column)this.columns.get(this.columns.size() - 1);
            lastColumn.setWidth(lastColumn.getWidth() + this.getWidth() - mergedColumnsWidth);
        } else {
            this.setWidth(mergedColumnsWidth);
        }
    }
}

