/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.dataexporter;

import com.complexible.common.dataexporter.LogOutputter;
import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class LogJsonOuput
implements LogOutputter {
    private final List<Object[]> mPrefetchedRows;
    private int mPrefetchLimit = 1000;
    private long mResultCount;
    private final List<String> mColumns;
    private PrintStream mOut;

    public LogJsonOuput(PrintStream theOut, List<String> theColNames) {
        this.mOut = theOut;
        this.mColumns = theColNames;
        this.mPrefetchedRows = Lists.newArrayList();
    }

    @Override
    public long output() {
        if (this.mResultCount <= (long)this.mPrefetchLimit) {
            this.exportPretechedResults();
        }
        return this.mResultCount;
    }

    private void prefetchResult(Object ... theRow) {
        this.mPrefetchedRows.add(Arrays.copyOf(theRow, theRow.length));
    }

    private void printRow(Object ... theRow) {
        JSONObject top = new JSONObject();
        for (int i = 0; i < theRow.length; ++i) {
            try {
                top.put(this.mColumns.get(i), theRow[i]);
                continue;
            }
            catch (JSONException aEx) {
                throw new RuntimeException(aEx);
            }
        }
        this.mOut.println(top.toString());
    }

    private void exportPretechedResults() {
        for (Object[] aRow : this.mPrefetchedRows) {
            this.printRow(aRow);
        }
    }

    @Override
    public void addRow(Object ... theRow) {
        if (theRow.length != this.mColumns.size()) {
            throw new IllegalArgumentException("Invalid number of columns: " + theRow.length);
        }
        if (this.mResultCount < (long)this.mPrefetchLimit) {
            this.prefetchResult(theRow);
        } else {
            if (this.mResultCount == (long)this.mPrefetchLimit) {
                this.exportPretechedResults();
            }
            this.printRow(theRow);
        }
        ++this.mResultCount;
    }

    @Override
    public void setPrefetchLimit(int thePrefetchLimit) {
        this.mPrefetchLimit = thePrefetchLimit;
    }
}

