/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.dataexporter;

import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.Column;

public class FormattedColumn
extends Column {
    private final String format;

    public FormattedColumn(String name, String format, AlignType align) {
        super(name, name.length(), align);
        this.format = format;
    }

    public int getMaxRowHeight(CellDetails cellDetails) {
        return (int)Math.ceil((float)this.format(cellDetails).length() / (float)this.getWidth());
    }

    public String format(CellDetails cellDetails) {
        Object cellValue = cellDetails.getCellValue();
        if (cellValue == null) {
            return "";
        }
        try {
            return String.format(this.format, cellValue);
        }
        catch (Exception e) {
            return cellValue.toString();
        }
    }
}

