/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.collect.SkippingIterable;
import com.complexible.common.collect.SkippingIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class SkippingIterables {
    public static <T> long size(SkippingIterable<T> theIterable) {
        return SkippingIterables.consumeIterator(theIterable, Iterators::size).intValue();
    }

    public static <T> void forEach(SkippingIterable<T> theIterable, Consumer<T> theConsumer) {
        SkippingIterables.consumeIterator(theIterable, theIterator -> {
            theIterator.forEachRemaining(theConsumer);
            return null;
        });
    }

    public static <T, R> R consumeIterator(SkippingIterable<T> theIterable, Function<Iterator<T>, R> theProcessor) {
        try (SkippingIterator<T> aIterator = theIterable.iterator();){
            R r = theProcessor.apply(aIterator);
            return r;
        }
    }

    public static <T> List<T> toList(SkippingIterable<T> theIterable) {
        return SkippingIterables.consumeIterator(theIterable, Lists::newArrayList);
    }

    public static <T> long size(SkippingIterator<T> theIterator) {
        try (SkippingIterator<T> skippingIterator = theIterator;){
            long l = Iterators.size(theIterator);
            return l;
        }
    }

    public static <T> void forEach(SkippingIterator<T> theIterator, Consumer<T> theConsumer) {
        try (SkippingIterator<T> skippingIterator = theIterator;){
            theIterator.forEachRemaining(theConsumer);
        }
    }
}

