/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SingletonQueue<T> {
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final Condition notEmpty = this.lock.newCondition();
    private final T eoq;
    private T obj = null;
    private boolean empty = true;
    private boolean closed = false;

    public SingletonQueue(T eoq) {
        Preconditions.checkNotNull(eoq, (Object)"End of queue element cannot be null");
        this.eoq = eoq;
    }

    public boolean isFull() {
        return !this.empty;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public T getEOQ() {
        return this.eoq;
    }

    public void put(T x) throws InterruptedException {
        Preconditions.checkNotNull(x);
        this.lock.lock();
        try {
            while (!this.empty && !this.closed) {
                this.notFull.await();
            }
            if (this.closed) {
                return;
            }
            this.obj = x;
            this.empty = false;
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T take() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.empty && !this.closed) {
                this.notEmpty.await();
            }
            T x = this.empty ? this.eoq : this.obj;
            this.empty = true;
            this.notFull.signal();
            T t = x;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws InterruptedException {
        this.lock.lock();
        try {
            if (!this.closed) {
                this.closed = true;
                this.notEmpty.signalAll();
                this.notFull.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

