/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;

public class QueuedSortedIterator<T>
extends UnmodifiableIterator<T> {
    private final Queue<T> mQueue;
    private final Comparator<? super T> mComparator;
    private final PeekingIterator<T> mIt;
    private int maxSize = 0;

    public QueuedSortedIterator(PeekingIterator<T> theIt, Comparator<T> theComparator) {
        this(theIt, new PriorityQueue<T>(16, theComparator));
    }

    public QueuedSortedIterator(PeekingIterator<T> theIt, PriorityQueue<T> theQueue) {
        this.mIt = theIt;
        this.mComparator = theQueue.comparator();
        this.mQueue = theQueue;
    }

    public void add(T theElement) {
        this.mQueue.add(theElement);
        if (this.mQueue.size() > this.maxSize) {
            this.maxSize = this.mQueue.size();
        }
    }

    public boolean hasNext() {
        return this.mIt.hasNext() || !this.mQueue.isEmpty();
    }

    public T next() {
        int aCmp;
        int n = !this.mIt.hasNext() ? 1 : (aCmp = this.mQueue.isEmpty() ? -1 : this.mComparator.compare(this.mIt.peek(), this.mQueue.peek()));
        if (aCmp < 0) {
            return (T)this.mIt.next();
        }
        if (aCmp == 0) {
            this.mIt.next();
        }
        return this.mQueue.remove();
    }
}

