/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class NonDominatedSolutions<T extends Iterable<? extends Number>>
implements Collection<T> {
    private final List<T> mSolutions;
    private final List<Comparator<T>> mComparators;

    public NonDominatedSolutions(List<Comparator<T>> theComparators) {
        this(theComparators, 10);
    }

    public NonDominatedSolutions(List<Comparator<T>> theComparators, int initialCapacity) {
        this.mComparators = theComparators;
        this.mSolutions = new ArrayList<T>(initialCapacity);
    }

    private boolean dominates(T theSolution, T theOther) {
        boolean better = false;
        for (Comparator<T> theComparator : this.mComparators) {
            int comparison = theComparator.compare(theSolution, theOther);
            if (comparison < 0) {
                better = true;
                continue;
            }
            if (comparison <= 0) continue;
            return false;
        }
        return better;
    }

    private boolean removeDominated(T theSolution) {
        boolean isDominated = false;
        for (int i = this.mSolutions.size() - 1; i >= 0; --i) {
            if (this.dominates(theSolution, (Iterable)this.mSolutions.get(i))) {
                this.mSolutions.remove(i);
                continue;
            }
            if (!this.dominates((Iterable)this.mSolutions.get(i), theSolution)) continue;
            isDominated = true;
        }
        return isDominated;
    }

    @Override
    public boolean add(T theSolution) {
        assert (Iterators.size(theSolution.iterator()) == this.mComparators.size());
        if (this.removeDominated(theSolution)) {
            return false;
        }
        return this.mSolutions.add(theSolution);
    }

    public T get(int index) {
        return (T)((Iterable)this.mSolutions.get(index));
    }

    private List<Number> getExtremeValues(boolean reversed) {
        ArrayList<Iterable> extrema = new ArrayList<Iterable>(this.mComparators.size());
        ArrayList<Number> extremeValues = new ArrayList<Number>(this.mComparators.size());
        int reversing = reversed ? -1 : 1;
        for (Iterable solution : this.mSolutions) {
            Iterator iter = solution.iterator();
            for (int i = 0; i < this.mComparators.size(); ++i) {
                Number value = (Number)iter.next();
                if (extrema.size() <= i) {
                    extrema.add(solution);
                    extremeValues.add(value);
                    continue;
                }
                if (reversing * this.mComparators.get(i).compare(solution, (Iterable)extrema.get(i)) >= 0) continue;
                extrema.set(i, solution);
                extremeValues.set(i, value);
            }
        }
        return extremeValues;
    }

    public List<? extends Number> getIdealPoint() {
        return this.getExtremeValues(false);
    }

    public List<? extends Number> getNadirPoint() {
        return this.getExtremeValues(true);
    }

    @Override
    public int size() {
        return this.mSolutions.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mSolutions.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.mSolutions.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mSolutions.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.mSolutions.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.mSolutions.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.mSolutions.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mSolutions.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (Iterable item : c) {
            changed |= this.add((T)item);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.mSolutions.remove(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.mSolutions.retainAll(c);
    }

    @Override
    public void clear() {
        this.mSolutions.clear();
    }
}

