/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.collect.AbstractSkippingIterator;
import com.complexible.common.collect.PeekingSkippingIterator;
import com.complexible.common.collect.RestrictedMarkResetIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class MarkResetSkippingIterator<T>
extends AbstractSkippingIterator<T>
implements RestrictedMarkResetIterator<T> {
    private final PeekingSkippingIterator<T> mIterator;
    private T mMark = null;
    private T mNext = null;
    private Predicate<T> mRestriction = t -> true;

    public MarkResetSkippingIterator(PeekingSkippingIterator<T> theIterator) {
        super(theIterator.comparator());
        this.mIterator = theIterator;
    }

    @Override
    public void restrict(Predicate<T> restriction) {
        this.mRestriction = restriction;
    }

    @Override
    protected T computeNext() {
        if (this.mNext != null) {
            return this.consume();
        }
        if (!this.mIterator.hasNext()) {
            return this.endOfData();
        }
        Object next = this.mIterator.peek();
        if (this.mRestriction.test(next)) {
            this.mIterator.next();
            return (T)next;
        }
        return this.endOfData();
    }

    private T consume() {
        T result = this.mNext;
        this.mNext = null;
        return result;
    }

    @Override
    protected T computeSkipTo(T theTarget) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void performReset() {
        this.mMark = null;
        this.mNext = null;
        this.mIterator.reset();
    }

    @Override
    public void mark(T mark) {
        this.mMark = mark;
        assert (this.mRestriction.test(this.mMark));
    }

    @Override
    public void resetToMark() {
        if (this.mMark == null) {
            throw new NoSuchElementException();
        }
        this.resetState();
        this.mIterator.reset();
        if (this.mIterator.skipTo(this.mMark)) {
            this.mNext = this.mIterator.next();
            assert (this.mIterator.comparator().compare(this.mNext, this.mMark) == 0) : "the mark should be a part of the iterators output";
        } else {
            throw new NoSuchElementException();
        }
    }

    @Override
    public MarkResetSkippingIterator<T> copy() {
        return new MarkResetSkippingIterator<T>(this.mIterator);
    }
}

