/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BoundedBuffer<T> {
    protected final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final Condition notEmpty = this.lock.newCondition();
    private final T[] items;
    private int tail;
    private int head;
    private int count;

    public BoundedBuffer(int size) {
        this.items = new Object[size];
    }

    public void put(T x) throws InterruptedException {
        this.lock.lock();
        try {
            while (this.count == this.items.length) {
                this.notFull.await();
            }
            this.items[this.tail] = x;
            if (++this.tail == this.items.length) {
                this.tail = 0;
            }
            ++this.count;
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T take() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            T x = this.items[this.head];
            this.items[this.head] = null;
            if (++this.head == this.items.length) {
                this.head = 0;
            }
            --this.count;
            this.notFull.signal();
            T t = x;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void putUninterruptibly(T x) {
        boolean interrupted = false;
        while (true) {
            try {
                this.put(x);
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public T takeUninterruptibly() {
        boolean interrupted = false;
        while (true) {
            try {
                T t = this.take();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.count = 0;
            this.tail = 0;
            this.head = 0;
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

