/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.collect;

import com.complexible.common.collect.BidirectionalIterator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class BidirectionalIterators {
    private static final BidirectionalIterator<Object> EMPTY = new IndexedBidirectionalIterator<Object>(0, 0){

        @Override
        protected Object get(int theIndex) {
            throw new NoSuchElementException();
        }
    };

    private BidirectionalIterators() {
        throw new AssertionError();
    }

    public static <T> BidirectionalIterator<T> emptyIterator() {
        return EMPTY;
    }

    public static <T> BidirectionalIterator<T> singletonIterator(final T theElement) {
        return new IndexedBidirectionalIterator<T>(0, 1){

            @Override
            protected T get(int theIndex) {
                if (theIndex != 0) {
                    throw new NoSuchElementException();
                }
                return theElement;
            }
        };
    }

    public static <T> BidirectionalIterator<T> forArray(T ... theElements) {
        return BidirectionalIterators.forArray(theElements, 0, theElements.length);
    }

    public static <T> BidirectionalIterator<T> forArray(final T[] theElements, int theOffset, int theLimit) {
        Preconditions.checkArgument((theLimit <= theElements.length ? 1 : 0) != 0);
        return new IndexedBidirectionalIterator<T>(theOffset, theLimit){

            @Override
            protected T get(int theIndex) {
                return theElements[theIndex];
            }
        };
    }

    public static <T> BidirectionalIterator<T> forList(final List<T> theElements) {
        return new IndexedBidirectionalIterator<T>(0, theElements.size()){

            @Override
            protected T get(int theIndex) {
                return theElements.get(theIndex);
            }
        };
    }

    public static <T> BidirectionalIterator<T> concat(BidirectionalIterator<? extends T> ... theIterators) {
        return new ConcatBidirectionalIterator(Iterators.forArray((Object[])theIterators));
    }

    public static <T> BidirectionalIterator<T> concat(Iterable<? extends BidirectionalIterator<? extends T>> theIterators) {
        return new ConcatBidirectionalIterator(theIterators.iterator());
    }

    public static <T> BidirectionalIterator<T> concat(Iterator<? extends BidirectionalIterator<? extends T>> theIterators) {
        return new ConcatBidirectionalIterator(theIterators);
    }

    public static <T> BidirectionalIterator<T> rest(BidirectionalIterator<T> theIterator) {
        return !theIterator.hasPrevious() ? theIterator : new RestBidirectionalIterator(theIterator);
    }

    private static class ConcatBidirectionalIterator<T>
    extends UnmodifiableIterator<T>
    implements BidirectionalIterator<T> {
        private final BidirectionalIterator<BidirectionalIterator<? extends T>> mIterators;
        private BidirectionalIterator<? extends T> mCurrIterator;
        private int mAdvanceCounter = 0;

        protected ConcatBidirectionalIterator(Iterator<? extends BidirectionalIterator<? extends T>> theIterators) {
            ArrayList aList = Lists.newArrayList();
            while (theIterators.hasNext()) {
                BidirectionalIterator<T> aIterator = theIterators.next();
                if (!aIterator.hasNext()) continue;
                aList.add(aIterator);
            }
            this.mIterators = BidirectionalIterators.forList(aList);
            this.mCurrIterator = this.mIterators.hasNext() ? (BidirectionalIterator)this.mIterators.next() : BidirectionalIterators.emptyIterator();
        }

        @Override
        public boolean hasPrevious() {
            return this.mCurrIterator.hasPrevious() || this.mAdvanceCounter > 1;
        }

        @Override
        public T previous() {
            if (!this.mCurrIterator.hasPrevious()) {
                this.mIterators.previous();
                this.mCurrIterator = this.mIterators.previous();
            }
            return this.mCurrIterator.previous();
        }

        @Override
        public boolean hasNext() {
            return this.mCurrIterator.hasNext() || this.mIterators.hasNext();
        }

        @Override
        public T next() {
            if (!this.mCurrIterator.hasNext()) {
                ++this.mAdvanceCounter;
                this.mCurrIterator = (BidirectionalIterator)this.mIterators.next();
            }
            return (T)this.mCurrIterator.next();
        }
    }

    private static class RestBidirectionalIterator<T>
    extends UnmodifiableIterator<T>
    implements BidirectionalIterator<T> {
        private final BidirectionalIterator<T> mIterator;
        private int mAdvanceCounter = 0;

        protected RestBidirectionalIterator(BidirectionalIterator<T> theIterator) {
            this.mIterator = theIterator;
        }

        @Override
        public boolean hasPrevious() {
            return this.mAdvanceCounter > 0 && this.mIterator.hasPrevious();
        }

        @Override
        public T previous() {
            if (this.mAdvanceCounter <= 0) {
                throw new NoSuchElementException();
            }
            --this.mAdvanceCounter;
            return this.mIterator.previous();
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public T next() {
            Object aNext = this.mIterator.next();
            ++this.mAdvanceCounter;
            return (T)aNext;
        }
    }

    private static abstract class IndexedBidirectionalIterator<T>
    extends UnmodifiableIterator<T>
    implements BidirectionalIterator<T> {
        private final int mStart;
        private final int mEnd;
        private int mPos;

        private IndexedBidirectionalIterator(int theStart, int theEnd) {
            if (theStart < 0 || theStart > theEnd) {
                throw new IllegalArgumentException();
            }
            this.mStart = theStart;
            this.mEnd = theEnd;
            this.mPos = this.mStart;
        }

        @Override
        public boolean hasNext() {
            return this.mPos < this.mEnd;
        }

        @Override
        public T next() {
            if (this.mPos == this.mEnd) {
                throw new NoSuchElementException();
            }
            return this.get(this.mPos++);
        }

        @Override
        public boolean hasPrevious() {
            return this.mPos > this.mStart;
        }

        @Override
        public T previous() {
            if (this.mPos == this.mStart) {
                throw new NoSuchElementException();
            }
            return this.get(--this.mPos);
        }

        protected abstract T get(int var1);
    }
}

