/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cancellation;

import com.complexible.common.cancellation.CancelCheck;
import com.complexible.common.timer.Timer;
import com.google.common.base.MoreObjects;

public class TimeoutCancelCheck
implements CancelCheck {
    private final CancelCheck delegate;
    private final Timer timer;

    public TimeoutCancelCheck(CancelCheck theDelegate, Timer theTimer) {
        this.delegate = theDelegate;
        this.timer = theTimer;
    }

    private boolean isTimeout() {
        return this.timer.getElapsed() > this.timer.getTimeout() && this.timer.getTimeout() != 0L;
    }

    @Override
    public void check() {
        this.delegate.check();
        this.timer.check();
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled() || this.isTimeout();
    }

    @Override
    public String getCancellationMessage() {
        return (String)MoreObjects.firstNonNull((Object)this.delegate.getCancellationMessage(), (Object)(this.isTimeout() ? "The process timed out" : null));
    }
}

