/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cancellation;

import com.complexible.common.cancellation.CancelCheck;
import com.complexible.common.util.concurrent.DaemonExecutor;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class CancellationUtil {
    private static final int MONITOR_INTERVAL_MS = 500;

    public static void monitorAsync(Runnable process, Runnable killer, CancelCheck cancelCheck) {
        CancellationUtil.monitorAsync(() -> {
            process.run();
            return Optional.empty();
        }, killer, cancelCheck);
    }

    public static <T> T monitorAsync(Callable<T> process, Runnable killer, CancelCheck cancelCheck) {
        AtomicReference<Object> error = new AtomicReference<Object>(null);
        AtomicReference result = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        DaemonExecutor.get().execute(() -> {
            try {
                result.set(process.call());
            }
            catch (Throwable e) {
                error.set(e);
            }
            finally {
                latch.countDown();
            }
        });
        while (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS)) {
            cancelCheck.check(err -> killer.run());
        }
        if (error.get() != null) {
            Throwables.throwIfUnchecked((Throwable)error.get());
            throw new RuntimeException(error.get());
        }
        return (T)result.get();
    }

    public static void monitorSync(Runnable process, Runnable killer, CancelCheck cancelCheck) {
        CancellationUtil.monitorSync(() -> {
            process.run();
            return null;
        }, killer, cancelCheck);
    }

    public static <T> T monitorSync(Callable<T> process, Runnable killer, CancelCheck cancelCheck) {
        CountDownLatch latch = new CountDownLatch(1);
        DaemonExecutor.get().execute(() -> {
            while (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS)) {
                cancelCheck.check(err -> killer.run());
            }
        });
        try {
            T t = process.call();
            return t;
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, RuntimeException.class);
            throw new RuntimeException(e);
        }
        finally {
            latch.countDown();
        }
    }
}

