/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cancellation;

import com.complexible.common.cancellation.CancelCheck;
import com.complexible.common.cancellation.Cancellable;
import com.complexible.common.cancellation.DelegatingCancellationPoint;
import com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public interface CancellationPoint
extends AutoCloseable,
CancelCheck,
Cancellable {
    public String getProcessDescription();

    public void cancel();

    @Override
    @Nullable
    public String getCancellationMessage();

    public void wait(long var1, TimeUnit var3) throws InterruptedException, ExecutionException, TimeoutException;

    @Override
    public void close();

    public static CancellationPoint uncloseable(CancellationPoint cp) {
        return new DelegatingCancellationPoint(cp){

            @Override
            public void close() {
            }
        };
    }

    public static CancellationPoint forCancelCheck(final String description, final CancelCheck check) {
        Preconditions.checkNotNull((Object)check);
        return new CancellationPoint(){
            private static final String UNKNOWN_CAUSE = "";
            private final AtomicReference<String> mCause = new AtomicReference<Object>(null);

            @Override
            public void check() {
                check.check();
                String cause = this.mCause.get();
                if (cause != null) {
                    throw new CancellationException(description + " got cancelled" + (String)(!cause.equals(UNKNOWN_CAUSE) ? ": " + cause : UNKNOWN_CAUSE));
                }
            }

            @Override
            public boolean isCancelled() {
                return check.isCancelled() || this.mCause.get() != null;
            }

            @Override
            public String getProcessDescription() {
                return description;
            }

            @Override
            public void cancel() {
                this.cancel(UNKNOWN_CAUSE);
            }

            @Override
            public void cancel(String theCause) {
                this.mCause.compareAndSet(null, theCause);
            }

            @Override
            public String getCancellationMessage() {
                return check.isCancelled() ? check.getCancellationMessage() : this.mCause.get();
            }

            @Override
            public void wait(long timeout, TimeUnit unit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }
}

