/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cancellation;

import com.complexible.common.base.Disposable;
import com.complexible.common.base.SystemUtil;
import com.complexible.common.cancellation.CancellationPoint;
import com.complexible.common.cancellation.DefaultCancellationPoint;
import com.complexible.common.util.ThreadDump;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class CancellationManager
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CancellationManager.class);
    private final AtomicInteger mDisposeCounter = new AtomicInteger(0);
    private final int mCancelTimeoutMs;
    private final int mDatabaseLockTimeoutMs;
    private final int mShutdownTimeoutInMillis;
    private final ConcurrentHashMap<String, List<CancellationPoint>> mCancellationPoints = new ConcurrentHashMap();
    private final ConcurrentMap<String, ReentrantLock> mDatabaseSemaphores = new ConcurrentHashMap<String, ReentrantLock>();
    private final Semaphore mGlobalSemaphore = new Semaphore(Integer.MAX_VALUE);
    private final AtomicReference<Throwable> mDisposedStackTrace = new AtomicReference();
    private static final Function<String, ? extends RuntimeException> DEFAULT_THROWER = cause -> {
        throw new CancellationException((String)cause);
    };

    public CancellationManager() {
        this(SystemUtil.getPropertyAsInt("cancellation.timeout.millis", 30000), SystemUtil.getPropertyAsInt("cancellation.db.timeout.millis", 1000), SystemUtil.getPropertyAsInt("cancellation.shutdown.timeout.millis", 0));
    }

    public CancellationManager(int cancelTimeoutMs, int databaseLockTimeoutMs, int disposeTimeoutMs) {
        this.mCancelTimeoutMs = cancelTimeoutMs;
        this.mDatabaseLockTimeoutMs = databaseLockTimeoutMs;
        this.mShutdownTimeoutInMillis = disposeTimeoutMs;
        LOGGER.debug("Cancel timeout: {}\nShutdown timeout: {}", (Object)this.mCancelTimeoutMs, (Object)this.mShutdownTimeoutInMillis);
    }

    private static void checkDatabase(String theDatabaseName) {
        Preconditions.checkNotNull((Object)theDatabaseName);
        Preconditions.checkArgument((!theDatabaseName.equals("") ? 1 : 0) != 0, (Object)"Database name should not be empty");
    }

    public CancellationPoint registerCancellationPoint(String theCancellationMessage, String theDatabaseName) {
        return this.registerCancellationPoint(theCancellationMessage, theDatabaseName, DEFAULT_THROWER);
    }

    private CancellationPoint makeCancellationPoint(String theCancellationMessage, String theDatabaseName, Function<String, ? extends RuntimeException> theCancellationThrower) {
        List aCancellationPoints = this.mCancellationPoints.computeIfAbsent(theDatabaseName, k -> new CopyOnWriteArrayList());
        DefaultCancellationPoint aPoint = new DefaultCancellationPoint(theCancellationMessage, this, theDatabaseName, theCancellationThrower);
        aCancellationPoints.add(aPoint);
        LOGGER.debug("Registered a cancellation point for {} on {}", (Object)theCancellationMessage, (Object)theDatabaseName);
        return aPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancellationPoint registerCancellationPoint(String theCancellationMessage, String theDatabaseName, Function<String, ? extends RuntimeException> theCancellationThrower) {
        CancellationManager.checkDatabase(theDatabaseName);
        ReentrantLock aDbLock = this.getDatabaseLock(theDatabaseName);
        this.acquireSharedGlobalLock();
        try {
            this.assertNotDisposed();
            if (!aDbLock.tryLock(this.mDatabaseLockTimeoutMs, TimeUnit.MILLISECONDS)) {
                LOGGER.warn("Unable to acquire lock for database '{}'", (Object)theDatabaseName);
                LOGGER.warn("tryLock failed with timeout {} ms on {} (locked={} fair={} heldByCurrentThread={})", new Object[]{this.mDatabaseLockTimeoutMs, aDbLock, aDbLock.isLocked(), aDbLock.isFair(), aDbLock.isHeldByCurrentThread()});
                throw new IllegalStateException("Unable to acquire lock for database '" + theDatabaseName + "'");
            }
            try {
                CancellationPoint aPoint;
                CancellationPoint cancellationPoint = aPoint = this.makeCancellationPoint(theCancellationMessage, theDatabaseName, theCancellationThrower);
                this.releaseDatabaseLock(aDbLock);
                return cancellationPoint;
            }
            catch (Throwable throwable) {
                try {
                    this.releaseDatabaseLock(aDbLock);
                    throw throwable;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Unable to acquire lock for database {}", (Object)theDatabaseName, (Object)e);
                    throw new RuntimeException(e);
                }
            }
        }
        finally {
            this.releaseSharedGlobalLock();
        }
    }

    private void releaseDatabaseLock(ReentrantLock theDbLock) {
        theDbLock.unlock();
    }

    private void releaseSharedGlobalLock() {
        this.mGlobalSemaphore.release(1);
    }

    private void releaseExclusiveGlobalLock() {
        this.mGlobalSemaphore.release(Integer.MAX_VALUE);
    }

    private void acquireSharedGlobalLock() {
        if (!this.mGlobalSemaphore.tryAcquire(1)) {
            throw new IllegalStateException("The cancellation manager is being shutdown");
        }
    }

    private void acquireExclusiveGlobalLock() throws InterruptedException {
        this.mGlobalSemaphore.acquire(Integer.MAX_VALUE);
    }

    private ReentrantLock getDatabaseLock(String theDatabaseName) {
        return this.mDatabaseSemaphores.computeIfAbsent(theDatabaseName, theSemaphore -> new ReentrantLock());
    }

    public void registerDatabase(String theDatabaseName) {
        this.getDatabaseLock(theDatabaseName);
    }

    public void unregisterDatabase(String theDatabaseName) {
        ReentrantLock lock = (ReentrantLock)this.mDatabaseSemaphores.get(theDatabaseName);
        if (lock != null) {
            lock.lock();
            try {
                this.mDatabaseSemaphores.remove(theDatabaseName);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void assertNotDisposed() {
        if (this.mDisposeCounter.get() > 0) {
            throw new IllegalStateException("System has been disposed", this.mDisposedStackTrace.get());
        }
    }

    /*
     * Exception decompiling
     */
    public <T> T executeExclusiveDatabaseOperation(String theDatabaseName, String theProcessDescription, Runnable theForceClose, Callable<T> theWorker) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> T executeExclusiveDatabaseOperation(String theDatabaseName, String theProcessDescription, Callable<T> theWorker) {
        return this.executeExclusiveDatabaseOperation(theDatabaseName, theProcessDescription, null, theWorker);
    }

    public <T> T executeExclusiveDatabaseOperation(String theDatabaseName, String theProcessDescription, Runnable theForceClose, CheckedFunction<CancellationPoint, T> theWorker) {
        return (T)this.executeExclusiveDatabaseOperation(theDatabaseName, theProcessDescription, theForceClose, () -> {
            try (CancellationPoint c = this.makeCancellationPoint(theProcessDescription, theDatabaseName, DEFAULT_THROWER);){
                Object r = theWorker.apply(c);
                return r;
            }
        });
    }

    void unregisterCancellationPoint(CancellationPoint theCancellationPoint, String theDatabaseName) {
        CancellationManager.checkDatabase(theDatabaseName);
        List<CancellationPoint> aCancellationPoints = this.mCancellationPoints.get(theDatabaseName);
        if (aCancellationPoints != null) {
            aCancellationPoints.remove(theCancellationPoint);
            LOGGER.debug("Unregistered a cancellation point for {} on {}", (Object)theCancellationPoint.getProcessDescription(), (Object)theDatabaseName);
            if (aCancellationPoints.isEmpty()) {
                this.mCancellationPoints.remove(theDatabaseName);
            }
        }
    }

    public void cancel() {
        for (String theDatabaseName : this.mCancellationPoints.keySet()) {
            List<CancellationPoint> aCancellationPoints = this.mCancellationPoints.get(theDatabaseName);
            if (aCancellationPoints == null) continue;
            for (CancellationPoint thePoint : aCancellationPoints) {
                try {
                    thePoint.cancel();
                }
                catch (Throwable theException) {
                    LOGGER.info(theException.getMessage(), theException);
                }
            }
        }
    }

    public void predisposed() {
        if (this.mDisposeCounter.compareAndSet(0, 1)) {
            this.mDisposedStackTrace.set(new RuntimeException("System has been disposed"));
            this.cancel();
        }
    }

    public void cancel(String theDatabaseName) {
        CancellationManager.checkDatabase(theDatabaseName);
        LOGGER.debug("Canceling operations on {}, if any", (Object)theDatabaseName);
        List<CancellationPoint> aCancellationPoints = this.mCancellationPoints.get(theDatabaseName);
        if (aCancellationPoints == null) {
            return;
        }
        for (CancellationPoint thePoint : aCancellationPoints) {
            try {
                thePoint.cancel();
            }
            catch (Throwable theException) {
                LOGGER.info(theException.getMessage(), theException);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.mDisposeCounter.getAndAdd(2) > 1) {
            return;
        }
        this.cancel();
        this.waitAll(false);
        try {
            if (!this.mGlobalSemaphore.tryAcquire(Integer.MAX_VALUE, 10L, TimeUnit.SECONDS)) {
                LOGGER.error("Unable to acquire exclusive lock for disposal of CancellationManager");
                LOGGER.error("Thread-Dump: {}", (Object)ThreadDump.defaultDump(true));
                this.acquireExclusiveGlobalLock();
            }
        }
        catch (InterruptedException theE) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(theE);
        }
        try {
            if (this.mDisposedStackTrace.get() != null) {
                return;
            }
            this.cancel();
            this.waitAll(true);
            this.mDisposedStackTrace.set(new RuntimeException());
        }
        finally {
            this.mCancellationPoints.clear();
            this.mDatabaseSemaphores.clear();
            this.releaseExclusiveGlobalLock();
        }
    }

    private void waitAll(boolean block) {
        boolean checkEndTime = this.mShutdownTimeoutInMillis > 0;
        Stopwatch timer = checkEndTime ? Stopwatch.createStarted() : null;
        boolean dumpThreads = true;
        do {
            ArrayList<CancellationPoint> blocking = new ArrayList<CancellationPoint>();
            for (String theDatabaseName : this.mCancellationPoints.keySet()) {
                List<CancellationPoint> aCancellationPoints = this.mCancellationPoints.get(theDatabaseName);
                if (aCancellationPoints == null) continue;
                for (CancellationPoint thePoint : aCancellationPoints) {
                    try {
                        thePoint.wait((long)this.mCancelTimeoutMs, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException ex) {
                        blocking.add(thePoint);
                    }
                    catch (Throwable theException) {
                        LOGGER.info(theException.getMessage(), theException);
                    }
                }
            }
            if (blocking.isEmpty()) {
                return;
            }
            LOGGER.warn("Waiting for remaining '{}' cancellation points: {}", (Object)blocking.size(), blocking.stream().map(CancellationPoint::getProcessDescription).collect(Collectors.toSet()));
            if (!block || !dumpThreads) continue;
            LOGGER.warn("Thread-Dump: {}", (Object)ThreadDump.defaultDump(true));
            dumpThreads = false;
        } while (block && (!checkEndTime || timer.elapsed(TimeUnit.MILLISECONDS) < (long)this.mShutdownTimeoutInMillis));
        LOGGER.error("Shutting down despite having remaining cancellation points");
    }

    private void waitAll(List<CancellationPoint> aCancellationPoints, String theProcessDescription, int waitTimeMs) {
        Preconditions.checkNotNull(aCancellationPoints);
        Stopwatch timer = Stopwatch.createStarted();
        for (CancellationPoint thePoint : aCancellationPoints) {
            try {
                long remain = Duration.ofMillis(waitTimeMs).minus(timer.elapsed()).toMillis();
                if (remain > 0L) {
                    thePoint.wait(remain, TimeUnit.MILLISECONDS);
                }
            }
            catch (TimeoutException theE) {
                throw new IllegalStateException("Can't execute process '" + theProcessDescription + "' due to current active process " + String.valueOf(thePoint));
            }
            catch (Throwable theException) {
                Throwables.throwIfInstanceOf((Throwable)theException, RuntimeException.class);
                throw new RuntimeException(theException);
            }
            if (timer.elapsed(TimeUnit.MILLISECONDS) <= (long)waitTimeMs) continue;
            throw new IllegalStateException("Can't execute process '" + theProcessDescription + "' due to too many active processes");
        }
    }

    public void wait(String dbname, String theProcessDescription, int waitTimeMs) {
        List<CancellationPoint> cps = this.mCancellationPoints.getOrDefault(dbname, (List<CancellationPoint>)ImmutableList.of());
        this.waitAll(cps, theProcessDescription, waitTimeMs);
    }

    @VisibleForTesting
    public int countCancellationPoint(String db) {
        return this.mCancellationPoints.getOrDefault(db, (List<CancellationPoint>)ImmutableList.of()).size();
    }

    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

