/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cancellation;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface CancelCheck {
    public static final CancelCheck DUMMY = new CancelCheck(){

        @Override
        public void check() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public String getCancellationMessage() {
            return null;
        }
    };

    public void check();

    default public void check(Consumer<Exception> handler) {
        try {
            this.check();
        }
        catch (Exception e) {
            handler.accept(e);
            throw e;
        }
    }

    public boolean isCancelled();

    @Nullable
    public String getCancellationMessage();

    default public <T extends Exception> void throwIfCancelled(Function<String, T> theThrower) throws T {
        if (this.isCancelled()) {
            throw (Exception)theThrower.apply(this.getCancellationMessage());
        }
    }
}

