/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cache;

import com.complexible.common.cache.CacheKey;
import com.complexible.common.cache.Caches;
import com.complexible.common.cache.LongCacheKey;
import com.complexible.common.cache.SharedCache;
import com.complexible.common.cache.SharedLongCache;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class SharedCaches {
    public static <K, V> Supplier<SharedCache<K, V>> newSharedCache(ConcurrentMap<CacheKey<K>, V> cache) {
        AtomicInteger partitions = new AtomicInteger(0);
        return () -> new SharedCache(cache, partitions.getAndIncrement());
    }

    public static <K, V> Supplier<SharedCache<K, V>> newSharedCache(int initCapacity, int maxCapacity) {
        return SharedCaches.newSharedCache(Caches.newConcurrentCache(initCapacity, maxCapacity));
    }

    public static <V> Supplier<SharedLongCache<V>> newSharedLongCache(ConcurrentMap<LongCacheKey, V> cache) {
        AtomicInteger partitions = new AtomicInteger(0);
        return () -> new SharedLongCache(cache, partitions.getAndIncrement());
    }
}

